% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialMethodParameters.R
\name{TurningBands}
\alias{TurningBands}
\title{Create a parameter set specifying a turning bands simulation algorithm}
\usage{
TurningBands(nsim = 1, nBands = 1000, ...)
}
\arguments{
\item{nsim}{number of realisations desired}

\item{nBands}{number of bands desired for the decomposition of the 2D or 3D space in individual signals}

\item{...}{further parameters, currently ignored}
}
\value{
an S3-list of class "gmTurningBands" containing the few elements given as arguments
to the function. This is just a compact way to provide further functions such as \code{\link[=predict.gmSpatialModel]{predict.gmSpatialModel()}}
with appropriate triggers for choosing a prediction method or another, in this case for triggering
turning bands simulation.
}
\description{
Create a parameter set describing a turning bands algorithm to two-point simulation,
mostly for covariance or variogram-based gaussian random fields.
}
\examples{
(tbs_local = TurningBands(nsim=100, nBands=300))
## then run predict(..., pars=tbs_local)
}
