% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialModel.R
\name{as.gmSpatialModel}
\alias{as.gmSpatialModel}
\alias{as.gmSpatialModel.default}
\alias{as.gmSpatialModel.gstat}
\title{Recast spatial object to gmSpatialModel format}
\usage{
as.gmSpatialModel(object, ...)

\method{as.gmSpatialModel}{default}(object, ...)

\method{as.gmSpatialModel}{gstat}(object, V = NULL, ...)
}
\arguments{
\item{object}{object to recast}

\item{...}{extra parameters for generic functionality}

\item{V}{optional, if the original data in the sptail object was compositional, which logcontrasts
were used to express it? Thsi can be either one string of "alr", "ilr" or "clr", or else a
(Dx(D-1))-element matrix of logcontrasts to pass from compositions to logratios}
}
\value{
The same spatial object re-structured as a "gmSpatialModel", see \linkS4class{gmSpatialModel}
}
\description{
Recast a spatial data object model to format gmSpatialModel
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Recast spatial object to gmSpatialModel format

\item \code{gstat}: Recast spatial object to gmSpatialModel format
}}

\seealso{
Other gmSpatialModel: 
\code{\link{Predict}()},
\code{\link{gmSpatialModel-class}},
\code{\link{make.gmCompositionalGaussianSpatialModel}()},
\code{\link{make.gmCompositionalMPSSpatialModel}()},
\code{\link{make.gmMultivariateGaussianSpatialModel}()}
}
\concept{gmSpatialModel}
