% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{plot.gmEVario}
\alias{plot.gmEVario}
\title{Plot empirical variograms}
\usage{
\method{plot}{gmEVario}(
  x,
  xlim.up = NULL,
  xlim.lo = NULL,
  vdir.up = NULL,
  vdir.lo = NULL,
  varnames = dimnames(x$gamma)[[2]],
  type = "o",
  add = FALSE,
  commonAxis = TRUE,
  cov = attr(x, "type") == "covariance",
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{x}{object to print, of class gmEVario}

\item{xlim.up}{range of X values to be used for the diagrams of the upper triangle}

\item{xlim.lo}{range of X values to be used for the diagrams of the lower triangle}

\item{vdir.up}{in case of anisotropic variograms, indices of the directions to be plotted
on the upper triangle}

\item{vdir.lo}{..., indices of the directions to be plotted on the lower triangle}

\item{varnames}{variable names to be used}

\item{type}{string, controlling whether to plot lines, points, etc (see \code{\link{plot}})}

\item{add}{boolean, add stuff to an existing diagram?}

\item{commonAxis}{boolean, should vertical axes be shared by all plots in a row?}

\item{cov}{boolean, is this a covariance? (if FALSE, it is a variogram)}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}

\item{...}{further parameters to \code{\link{matplot}}}
}
\value{
invisibly, the graphical parameters active before calling the function.
This is useful for freezing the plot if you provided \code{closeplot=FALSE}.

How to use arguments \code{vdir.lo} and \code{vdir.up}? Each empirical variogram \code{x} has been
computed along certain distances, recorded in its attributes and retrievable with command
\code{\link{ndirections}}.
}
\description{
Flexible plot of an empirical variogram of class gmEVario
}
\examples{
library(gstat)
data("jura", package = "gstat")
X = as.matrix(jura.pred[,1:2])
Z = as.matrix(jura.pred[,c("Zn","Cd","Pb")])
vge = gsi.EVario2D(X,Z)
plot(vge)
plot(vge, pch=22, lty=1, bg="grey")
}
\seealso{
Other gmEVario functions: 
\code{\link{as.gmEVario}()},
\code{\link{gsi.EVario2D}()},
\code{\link{ndirections}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmEVario functions}
