% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{[.logratioVariogramAnisotropy}
\alias{[.logratioVariogramAnisotropy}
\alias{`[.logratioVariogram`}
\title{Subsetting of logratioVariogram objects}
\usage{
\method{[}{logratioVariogramAnisotropy}(x, i = NULL, j = NULL, ...)
}
\arguments{
\item{x}{an object of class "logratioVariogram" or c("logratioVariogramAnisotropy", "logratioVariogram")}

\item{i}{index or indexes of lags to be kept (if positive) or removed (if negative)}

\item{j}{index or indexes of directions to be kept, only for objects of class c("logratioVariogramAnisotropy", "logratioVariogram")}

\item{...}{extra arguments, ignored}
}
\value{
the selected variograms or lags, potentially of class "logratioVariogram" if only one direction is chosen
}
\description{
Subsetting of logratioVariogram objects
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:9])
vg = logratioVariogram(data=Zc, loc=X)
vg[1]
vg = logratioVariogram(data=Zc, loc=X, azimuth=c(0,90))
vg[,1]
vg[1,1]
vg[1,]
}
