% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rgraph}
\alias{rgraph}
\title{Random generation of acyclic digraphs and undirected graphs}
\usage{
rgraph(p, d, dag = FALSE)
}
\arguments{
\item{p}{Number of vertices of the sampled graph}

\item{d}{Proportion of edges in the generated graph}

\item{dag}{Whether the generated graph should be acyclic directed}
}
\value{
g The generated graph. If \code{dag = TRUE}, the nodes follow the
ancestral order \code{1, ..., p}, where \code{1} has no parents.
}
\description{
Wrapper of functionality from package \code{igraph} for random generation of
graphs.
}
\details{
When \code{dag = FALSE}, the graph is sampled from an Erdos-Renyi model.
In the case where \code{dag = TRUE}, the upper triangle of the adjacency matrix of
an Erdos-Renyi model is taken as the adjacency matrix for the acyclic
digraph. This preserves the proportion of edges \code{d}.
}
