% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipses.R
\name{ellipses}
\alias{ellipses}
\title{Display the mixture components of a Gaussian mixture model}
\usage{
ellipses(
  gmm,
  data = NULL,
  y = rownames(gmm$mu),
  x = rownames(gmm$mu),
  level = 0.95
)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{data}{A data frame or numeric matrix containing the data displayed with
the mixture components. Its columns must explicitly be named after the
variables of \code{gmm}. If \code{NULL} (the default), no data is displayed.}

\item{y}{A character vector containing the variables displayed on the y-axis
(by default all the variables of \code{gmm}).}

\item{x}{A character vector containing the variables displayed on the x-axis
(by default all the variables of \code{gmm}).}

\item{level}{A numeric value in [0, 1[ corresponding to the confidence level
of the ellipses.}
}
\value{
A \code{ggplot} object displaying the mixture components (and the
data if required).
}
\description{
This function displays the mixture components of a Gaussian mixture model.
For each pair of variables, the covariance matrices are represented by
confidence ellipses.
}
\examples{
set.seed(0)
data(gmm_body)
ellipses(gmm_body, sampling(gmm_body, n = 500))

}
