% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{aggregation}
\alias{aggregation}
\title{Aggregate particles to obtain inferred values}
\usage{
aggregation(part, nodes, col_seq = NULL, col_weight = "weight", lag = 0)
}
\arguments{
\item{part}{A data frame containing the particles propagated to time slice
\eqn{t}, as obtained from function \code{\link{particles}} or
\code{\link{propagation}}.}

\item{nodes}{A character vector containing the inferred nodes.}

\item{col_seq}{A character vector containing the column names of \code{part}
that describe the observation sequence. If \code{NULL} (the default), all the
particles belong to a single sequence.}

\item{col_weight}{A character string corresponding to the column name of
\code{part} that describes the particle weight.}

\item{lag}{A non-negative integer vector containing the time lags \eqn{l_1,
l_2, \dots}{l1, l2, \dots} such that the samples of time slices \eqn{t - l_1,
t - l_2, \dots}{t - l1, t - l2, \dots} are aggregated.}
}
\value{
If \code{lag} has one element, a data frame (tibble) containing the
aggregated values of the inferred nodes and their observation sequences (if
\code{col_seq} is not \code{NULL}). If \code{lag} has two or more elements, a
list of data frames (tibbles) containing these values for each time lag.
}
\description{
This function aggregates particles to obtain inferred values. Assuming that
the particles have been propagated to a given time slice \eqn{t}, the
weighted average of the samples is computed to estimate the state of the
system at \eqn{t} or at previous time slices (Koller and Friedman, 2009).
}
\examples{
\donttest{
library(dplyr)
set.seed(0)
data(gmdbn_air, data_air)
evid <- data_air \%>\%
  group_by(DATE) \%>\%
  slice(1:3) \%>\%
  ungroup()
evid$NO2[sample.int(150, 30)] <- NA
evid$O3[sample.int(150, 30)] <- NA
evid$TEMP[sample.int(150, 30)] <- NA
evid$WIND[sample.int(150, 30)] <- NA
aggreg <- particles(data.frame(DATE = unique(evid$DATE))) \%>\%
  propagation(gmdbn_air, evid, col_seq = "DATE", n_times = 3) \%>\%
  aggregation(c("NO2", "O3", "TEMP", "WIND"), col_seq = "DATE", lag = c(0, 1))}

}
\references{
Koller, D. and Friedman, N. (2009). \emph{Probabilistic Graphical Models:
Principles and Techniques}. The MIT Press.
}
\seealso{
\code{\link{aggregation}}, \code{\link{particles}}
}
