% $Id: CrossTable.Rd,v 1.1.1.1 2005/05/25 22:13:00 nj7w Exp $
%
\name{CrossTable}
\alias{CrossTable}
\title{Cross Tabulation with Tests for Factor Independence}
\description{
  An implementation of a cross-tabulation function with output
  similar to S-Plus crosstabs() and SAS Proc Freq (or SPSS format)
  with Chi-square, Fisher and McNemar tests of the independence
  of all table factors.
  }
\usage{
CrossTable(x, y, digits=3, max.width = 5, expected=FALSE, prop.r=TRUE, prop.c=TRUE,
           prop.t=TRUE, prop.chisq=TRUE, chisq = FALSE, fisher=FALSE, mcnemar=FALSE,
           resid=FALSE, sresid=FALSE, asresid=FALSE,
           missing.include=FALSE,
format=c("SAS","SPSS"),...)
}
\arguments{
  \item{x}{A vector or a matrix. If y is specified, x must be a vector}
  \item{y}{A vector in a matrix or a dataframe}
  \item{digits}{Number of digits after the decimal point for cell
    proportions}
  \item{max.width}{In the case of a 1 x n table, the default will be
		to print the output horizontally. If the number of columns exceeds
		max.width, the table will be wrapped for each successive increment
		of max.width columns. If you want a single column vertical table,
		set max.width to 1}
  \item{expected}{If \code{TRUE}, chisq will be set to \code{TRUE} and
		expected cell counts from the \eqn{\chi^2}{Chi-Square} will be
		included}
  \item{prop.r}{If \code{TRUE}, row proportions will be included}
  \item{prop.c}{If \code{TRUE}, column proportions will be included}
  \item{prop.t}{If \code{TRUE}, table proportions will be included}
  \item{prop.chisq}{If \code{TRUE}, chi-square contribution of each cell will be included}
  \item{chisq}{If \code{TRUE}, the results of a chi-square test will
		be included}
  \item{fisher}{If \code{TRUE}, the results of a Fisher Exact test will
     be included}
  \item{mcnemar}{If \code{TRUE}, the results of a McNemar test will
     be included}
   \item{resid}{If \code{TRUE}, residual (Pearson) will be included}
   \item{sresid}{If \code{TRUE},  standardized residual will be included}
   \item{asresid}{If \code{TRUE}, adjusted standardized residual will be included}
   \item{missing.include}{If \code{TRUE}, then remove any unused factor levels}
  \item{format}{Either SAS (default) or SPSS, depending on the type of
    output desired.}
  \item{...}{additional arguments passed on table}

 }
\details{
  A summary table will be generated with cell row, column and table
  proportions and marginal totals and proportions. Expected cell counts
  can be printed if desired (if 'chisq = TRUE'). In the case of a 2 x 2
	table, both corrected and uncorrected values will be included for
	appropriate tests. In the case of tabulating a single vector, cell
	counts and table proportions will be printed.

  Note: If 'x' is a vector and 'y' is not specified, no statistical tests
	will be performed, even if any are set to \code{TRUE}.
}
\value{
  A list with multiple components including key table data and
  statistical test results, where performed.

  t:            An n by m matrix containing table cell counts

  prop.col:     An n by m matrix containing cell column proportions

  prop.row:     An n by m matrix containing cell row proportions

  prop.tbl:     An n by m matrix containing cell table proportions

  chisq:        Results from the Chi-Square test. A list with class
                'htest'. See ?chisq.test for details

  chisq.corr:   Results from the corrected Chi-Square test. A list with
                class 'htest'. See ?chisq.test for details. ONLY
                included in the case of a 2 x 2 table.

  fisher.ts:    Results from the two-sided Fisher Exact test. A list
                with class 'htest'. See ?fisher.test for details. ONLY
                included if 'fisher' = TRUE.

  fisher.lt:    Results from the Fisher Exact test with HA = "less". A
                list with class 'htest'. See ?fisher.test for details.
                ONLY included if 'fisher' = TRUE and in the case of a
                2 x 2 table.

  fisher.gt:    Results from the Fisher Exact test with HA = "greater".
                A list with class 'htest'. See ?fisher.test for details.
                ONLY included if 'fisher' = TRUE and in the case of a
                2 x 2 table.

  mcnemar:      Results from the McNemar test. A list with class
                'htest'. See ?mcnemar.test for details. ONLY included
                if 'mcnemar' = TRUE.

  mcnemar.corr: Results from the corrected McNemar test. A list with
                class 'htest'. See ?mcnemar.test for details. ONLY
                included if 'mcnemar' = TRUE and in the case of a
                2 x 2 table.

  resid/sresid/asresid: Pearson Residuals (from chi-square tests).
}
\author{Marc Schwartz \email{mschwartz@medanalytics.com}. Original
        version posted to r-devel on Jul 27, 2002.}

\seealso{\code{\link{xtabs}},
         \code{\link{table}},
         \code{\link{prop.table}}}

\examples{

# Simple cross tabulation of education versus prior induced abortions
# using infertility data
data(infert, package = "datasets")
CrossTable(infert$education, infert$induced, expected = TRUE)
CrossTable(infert$education, infert$induced, expected = TRUE, format="SAS")
CrossTable(infert$education, infert$induced, expected = TRUE, format="SPSS")
}
\keyword{category}
\keyword{univar}
