% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_ind2}
\alias{random_ind2}
\title{Create somewhat random parameter vector of GMVAR model that is always stationary}
\usage{
random_ind2(p, M, d, mu_scale, mu_scale2, omega_scale, ar_scale = 1)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{number of time series in the system.}

\item{mu_scale}{a size \eqn{(dx1)} vector defining \strong{means} of the normal distributions from which each
mean parameter \eqn{\mu_{m}} is drawn from in random mutations. Default is \code{colMeans(data)}. Note that
mean-parametrization is always used for optimization in \code{GAfit()} - even when \code{parametrization=="intercept"}, but
input (in \code{initpop}) and output (return value) parameter vectors may be intercept-parametrized.}

\item{mu_scale2}{a size \eqn{(dx1)} strictly positive vector defining \strong{standard deviations} of the normal
distributions from which each mean parameter \eqn{\mu_{m}} is drawn from in random mutations.
Default is \code{sd(data[,i]), i=1,..,d}.}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart distribution.
Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard deviations
of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit()} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}.}

\item{ar_scale}{a positive real number adjusting how large AR-paramater values are typically generated in some random
mutations. See function \code{random_coefmats2()} for details. This is ignored when estimating constrained models.}
}
\value{
Returns somewhat random mean-parametrized parameter vector that has form \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon_{1}}},
 ...,\strong{\eqn{\upsilon_{M}}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
 \itemize{
   \item \strong{\eqn{\upsilon_{m}}} \eqn{ = (\mu_{m},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}
   \item \strong{\eqn{\phi_{m}}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,1})}
   \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
 }
}
\description{
\code{random_ind2} generates random mean-parametrized parameter vector
 that is always stationary
}
\details{
The coefficient matrices are generated using the algorithm described by Ansley
  and Kohn (1986), which forces stationarity. It's not clear in detail how \code{ar_scale}
  affects the coefficient matrices. Read the cited article by Ansley and Kohn (1986) AND
  the source code for more information.

  The covariance matrices are generated from (scaled) Wishart distribution.

  Constrained models are not supported!
}
\references{
\itemize{
   \item Ansley C.F., Kohn R. 1986. A note on reparameterizing a vector autoregressive
      moving average model to enforce stationarity.
      \emph{Journal of statistical computation and simulation}, \strong{24}:2,  99-106.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
