% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{estimate_sgsmvar}
\alias{estimate_sgsmvar}
\title{Maximum likelihood estimation of a structural GMVAR, StMVAR, or G-StMVAR model
 with preliminary estimates}
\usage{
estimate_sgsmvar(
  gsmvar,
  new_W,
  ncalls = 16,
  ncores = 2,
  maxit = 1000,
  seeds = NULL
)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{new_W}{What should be the constraints on the W-matrix (or equally B-matrix)? Provide a \eqn{(d x d)} matrix
(where \code{d} is the number of time series in the system) expressing the constraints such that \code{NA} signifies
that the element is not constrained, strictly positive real number signifies strict positive sign constraint,
strictly negative real number signified strict negative sign constraints, and zero signifies a zero constraints.}

\item{ncalls}{the number of estimation rounds that should be performed.}

\item{ncores}{the number of CPU cores to be used in numerical differentiation. Multiple cores
are not supported on Windows, though.}

\item{maxit}{the maximum number of iterations in the variable metric algorithm.}

\item{seeds}{a length \code{ncalls} vector containing the random number generator seed for each call to the genetic algorithm,
or \code{NULL} for not initializing the seed. Exists for creating reproducible results.}
}
\value{
Returns an object of class \code{'gsmvar'} defining the estimated GMVAR, StMVAR, or G-StMVAR model.
}
\description{
\code{estimate_gsmvar} uses a genetic algorithm and variable metric algorithm to estimate the parameters
 of a structural GMVAR, StMVAR, or G-StMVAR model with the method of maximum likelihood and preliminary
 estimates from (typically identified) reduced form or structural GSMVAR model.
}
\details{
The purpose of \code{estimate_gsmvar} is to provide a convenient tool to estimate (typically over)identified
  structural GSMVAR models when preliminary estimates are available from a fitted reduced form or structural GMVAR
  model. Often one estimates a two-regime reduced form model and then uses the function \code{gsmvar_to_sgsmvar} to
  obtain the corresponding, statistically identified structural model. After obtaining the statistically identified
  structural model, overidentifying constraints may be placed the W-matrix (or equally B-matrix). This function makes
  imposing the overidentifying constraints and estimating the overidentified structural model convenient.

  \strong{Note that the surface of the log-likelihood function is extremely multimodal, and this function is designed
  to only explore the neighbourhood of the preliminary estimates, so it finds its way reliably to the correct MLE
  only the preliminary estimates are close it in the first place. Use the function directly fitGSMVAR for a more thorough
  search of the parameter space, if necessary.} This function calls \code{fitGSMVAR} by construction an initial population to
  the genetic algorithm from a preliminary guess of the new estimates. The smart mutations are set to begin from the
  first generation.

  In order to the impose the constraints you wish, it might be useful to first run the model through the functioons
  \code{reorder_W_columns} and \code{swap_W_signs}. \strong{Particularly check that the sign constraints are readily
  satisfied. If not, the estimated solution might not be correct MLE.}

  \code{estimate_sgsmvar} can also be used to estimate models that are not identified, i.e., one regime models. If it
  supplied with a reduced form model, it will first apply the function \code{gsmvar_to_sgsmvar}, then impose the
  constraints and finally estimate the model.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!
## Running the below examples takes 30 seconds

# GMVAR(1,2) model
fit12 <- fitGSMVAR(gdpdef, p=1, M=2, ncalls=2, seeds=1:2) # Reduced form
fit12s <- gsmvar_to_sgsmvar(fit12) # Structural
fit12s
# Constrain the lower right element of W (or B-matrix) to zero, and for
# global identification the first elements of each column to strictly positive.
(new_W <- matrix(c(1, NA, 1, 0), nrow=2))
new_fit12s <- estimate_sgsmvar(fit12s, new_W, ncalls=2, ncores=2, seeds=1:2)
new_fit12s # Overidentified model

# Cholesky VAR(1)
fit11 <- fitGSMVAR(gdpdef, p=1, M=1, ncalls=2, seeds=1:2) # Reduced form
(new_W <- matrix(c(1, NA, 0, 1), nrow=2))
new_fit11s <- estimate_sgsmvar(fit11, new_W, ncalls=2, ncores=2, seeds=1:2)
print(new_fit11s, digits=4)
# Also: gsmvar_to_sgsmvar(fit11, cholesky=TRUE) gives Cholesky VAR
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2021. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Virolainen S. 2021. Gaussian and Student's t mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2109.13648.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link[stats]{optim}},
 \code{\link{profile_logliks}}, \code{\link{iterate_more}} \code{\link{gsmvar_to_sgsmvar}}
}
