% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{rgenpois}
\alias{rgenpois}
\title{Simulate realisations from a generalised poisson distribution}
\usage{
rgenpois(mu, phi)
}
\arguments{
\item{mu}{A numeric vector of rates \eqn{\exp{\eta}}, with \eqn{\eta} the linear predictor.}

\item{phi}{A numeric specifying the dispersion \eqn{\varphi}. If \eqn{\varphi<0} the response 
will be under-dispersed and overdispersed if \eqn{\varphi>0}.}
}
\value{
An appropriately-dimensioned vector of count data.
}
\description{
Simulate realisations from a generalised poisson distribution
}
\details{
Follows the "GP-1" implementation of the generalised Poisson distribution outlined 
in Zamani & Ismail (2012). The variance of produced \eqn{Y} is \eqn{(1+\varphi)^2\mu}.
}
\references{
Zamani H and Ismail N. Functional Form for the Generalized Poisson Regression Model, 
\emph{Communications in Statistics - Theory and Methods} 2012; \strong{41(20)}; 3666-3675.
}
