% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{plot.ROC.joint}
\alias{plot.ROC.joint}
\title{Plot receiver operator characteristics.}
\usage{
\method{plot}{ROC.joint}(x, legend = TRUE, show.Youden = TRUE, show.F1 = FALSE, ...)
}
\arguments{
\item{x}{an object with class \code{ROC.joint}.}

\item{legend}{should a legend displaying the number in risk set; number of failures in interval;
area under the ROC curve and median Brier score be added to the bottom-right corner of the ROC 
plot? Default is \code{legend = TRUE}.}

\item{show.Youden}{should a line be drawn showing optimal cut-point using Youden's J statistic?
Defaults to \code{show.Youden = TRUE}.}

\item{show.F1}{should a line be drawn showing optimal cut-point using the F-score?
Defaults to \code{show.F1 = FALSE}. Note that this measure comes under heavy criticism and is
included for completeness' sake.}

\item{...}{additional arguments (none used).}
}
\description{
Produces a simple plot showing the true positive rate (sensitivity) against
the false positive rate (1-specificy) for a dynamic prediction routine on a \code{joint} model
along a specified time interval.
}
\seealso{
\code{\link{dynPred}} and \code{\link{ROC}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
\keyword{internal}
