% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMWM.R
\name{gmwm}
\alias{gmwm}
\title{GMWM for Sensors, ARMA, SSM, and Robust}
\usage{
gmwm(model, data, model.type = "ssm", compute.v = "auto",
  augmented = FALSE, robust = FALSE, eff = 0.6, alpha = 0.05,
  seed = 1337, G = NULL, K = 1, H = 100)
}
\arguments{
\item{model}{A \code{ts.model} object containing one of the allowed models.}

\item{data}{A \code{matrix} or \code{data.frame} object with only column (e.g. \eqn{N \times 1}{ N x 1 }), or a \code{lts} object, or a \code{gts} object.}

\item{model.type}{A \code{string} containing the type of GMWM needed e.g. sensor or SSM}

\item{compute.v}{A \code{string} indicating the type of covariance matrix solver. "fast", "bootstrap", "asymp.diag", "asymp.comp", "fft"}

\item{augmented}{A \code{boolean} indicating whether to add additional moments (e.g. mean for drift and variance for all other components).}

\item{robust}{A \code{boolean} indicating whether to use the robust computation (TRUE) or not (FALSE).}

\item{eff}{A \code{double} between 0 and 1 that indicates the efficiency.}

\item{alpha}{A \code{double} between 0 and 1 that correspondings to the \eqn{\frac{\alpha}{2}}{alpha/2} value for the wavelet confidence intervals.}

\item{seed}{A \code{integer} that controls the reproducibility of the auto model selection phase.}

\item{G}{An \code{integer} to sample the space for sensor and SSM models to ensure optimal identitability.}

\item{K}{An \code{integer} that controls how many times the bootstrapping procedure will be initiated.}

\item{H}{An \code{integer} that indicates how many different samples the bootstrap will be collect.}
}
\value{
A \code{gmwm} object that contains:
\itemize{
 \item{}
 \item{}
 \item{}
}
}
\description{
GMM object
}
\details{
This function is under work. Some of the features are active. Others... Not so much. 
What is NOT active:
1. Augmented GMWM (additional moments)

The V matrix is calculated by:
\eqn{diag\left[ {{{\left( {Hi - Lo} \right)}^2}} \right]}{diag[(Hi-Lo)^2]}.

The function is implemented in the following manner:
1. Calculate MODWT of data with levels = floor(log2(data))
2. Apply the brick.wall of the MODWT (e.g. remove boundary values)
3. Compute the empirical wavelet variance (WV Empirical).
4. Obtain the V matrix by squaring the difference of the WV Empirical's Chi-squared confidence interval (hi - lo)^2
5. Optimize the values to obtain \eqn{\hat{\theta}}{theta^hat}
6. If FAST = TRUE, return these results. Else, continue.

Loop  k = 1 to K
Loop h = 1 to H
7. Simulate xt under \eqn{F_{\hat{\theta}}}{F_theta^hat}
8. Compute WV Empirical
END
9. Calculate the covariance matrix
10. Optimize the values to obtain \eqn{\hat{\theta}}{theta^hat}
END
11. Return optimized values.


The function estimates a variety of time series models. If type = "imu" or "SSM", then
parameter vector should indicate the characters of the models that compose the latent or state-space model. The model
options are:
\itemize{
  \item{"AR1"}{a first order autoregressive process with parameters \eqn{(\phi,\sigma^2)}{phi, sigma^2}}
  \item{"ARMA"}{an autoregressive moving average process with parameters \eqn{(\phi _p, \theta _q, \sigma^2)}{phi[p], theta[q], sigma^2}}
  \item{"DR"}{a drift with parameter \eqn{\omega}{omega}}
  \item{"QN"}{a quantization noise process with parameter \eqn{Q}}
  \item{"RW"}{a random walk process with parameter \eqn{\sigma^2}{sigma^2}}
  \item{"WN"}{a white noise process with parameter \eqn{\sigma^2}{sigma^2}}
}
If type = "ARMA", the function takes condition least squares as starting values; if type = "imu" or type = "SSM" then
starting values pass through an initial bootstrap and pseudo-optimization before being passed to the GMWM optimization.
If robust = TRUE the function takes the robust estimate of the wavelet variance to be used in the GMWM estimation procedure.
}
\examples{
# AR
set.seed(1336)
n = 200
data = gen.gts(AR1(phi = .99, sigma2 = 0.01) + WN(sigma2 = 1), n)

# Models can contain specific parameters e.g.
adv.model = gmwm(AR1(phi = .99, sigma2 = 0.01) + WN(sigma2 = 0.01),
                            data)

# Or we can guess the parameters:
guided.model = gmwm(AR1() + WN(), data) 

# Want to try different models? 
guided.ar1 = gmwm(AR1(), data)

# Faster:
guided.ar1.wn.prev = update(guided.ar1, AR1()+WN())

# OR 

# Create new GMWM object. 
# Note this is SLOWER since the Covariance Matrix is recalculated.
guided.ar1.wn.new = gmwm(AR1()+WN(), data)
 
# ARMA case
set.seed(1336)
data = arima.sim(n = 200, 
              list(ar = c(0.8897, -0.4858), ma = c(-0.2279, 0.2488)),
              sd = sqrt(0.1796))
#guided.arma = gmwm(ARMA(2,2), data, model.type="ssm")
adv.arma = gmwm(ARMA(ar=c(0.8897, -0.4858), ma = c(-0.2279, 0.2488), sigma2=0.1796),
                data, model.type="ssm")
}

