% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lts.R
\name{plot.lts}
\alias{plot.lts}
\title{Wrapper Function to Plot the Graph of Latent Time Series}
\usage{
\method{plot}{lts}(x, to.unit = NULL, background = "white",
  scales = "free", line.type = NULL, line.color = NULL,
  point.size = NULL, point.shape = NULL, title = NULL, title.size = 15,
  axis.label.size = 13, axis.tick.size = 11, axis.x.label = NULL,
  axis.y.label = NULL, facet.label.size = 13, ncol = 1, nrow = NULL,
  ...)
}
\arguments{
\item{x}{A \code{lts} object}

\item{to.unit}{A \code{string} indicating the unit which the data is converted to. The supported units are "ns"(nanosecond), "ms"(millisecond), "sec", "min", "hour", "day", "month", and "year".}

\item{background}{A \code{string} that determines the graph background. It can be "grey" or "white".}

\item{scales}{Same as \code{scales} in \code{facet_wrap()} in \code{ggplot2} package: should scales be fixed ("fixed"), free ("free"), or free in one dimension ("free_x", "free_y"). The default is "free" in this function.}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of lines.}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of lines.}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of points on lines.}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of points on lines.}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label.}

\item{ncol}{An \code{integer} that indicates number of columns.}

\item{nrow}{An \code{integer} that indicates number of rows.}

\item{...}{other arguments passed to specific methods.}
}
\value{
A ggplot2 panel containing the graph of latent time series.
}
\description{
This function is implemented with ggplot2.
}
\examples{
model = AR1(phi = .99, sigma = 1) + WN(sigma2=1)
res = gen.lts(model)
plot(res)
}
\author{
Wenchao
}

