% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_methods.R
\name{auto.imu}
\alias{auto.imu}
\title{Automatically select appropriate model for IMU}
\usage{
auto.imu(data, model = 3 * AR1() + WN() + RW() + QN() + DR(), bootstrap = F,
  alpha = 0.05, robust = F, eff = 0.6, B = 50, G = 1e+05,
  seed = 1337)
}
\arguments{
\item{data}{A \code{vector}, \code{matrix}, \code{data.frame}, or \code{imu} object with either 1, 3, or 6 columns.}

\item{model}{A \code{ts.model} object that is the largest model to be tested.}

\item{bootstrap}{A \code{bool} that is either true or false to indicate whether we use bootstrap or asymptotic By default, we use asymptotic.}

\item{alpha}{A \code{double} that indicates the level of confidence for the WV CI.}

\item{robust}{A \code{boolean} that indicates whether to use robust estimation.}

\item{eff}{A \code{double} between 0 and 1 that indicates the efficiency for the robust estimation.}

\item{B}{A \code{integer} that contains the amount of bootstrap replications}

\item{G}{A \code{integer} that indicates the amount of guesses for caliberating the startup.}

\item{seed}{A \code{integer} that controls the reproducibility of the auto model selection phase.}
}
\value{
A \code{auto.imu} object.
}
\description{
Runs through a model selection algorithm to determine the best model
}
\details{
The \code{auto.imu} object stores two important features for each signal:
\itemize{
\item{[[1]]}{A matrix containing model output}
\item{[[2]]}{The best \code{gmwm} object.}
}
To access it for each signal use:
\code{object[[i]][[1]]} or \code{object[[i]][[2]]}, where \eqn{i} denotes the signal.
}
\examples{
\dontrun{
if(!require("imudata")){
install_imudata()
library("imudata")
}

data(imu6)

# Example 1
test1 = imu(imu6, gyros = 1:3, accels = NULL, axis = c('X', 'Y', 'Z'), freq = 100)

m = auto.imu(test1)

# Process 1's model table
m[[1]][[1]]

# Process 1's best fitting gmwm object
m[[1]][[2]]

}
}
\author{
JJB
}

