% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getObjFunStarting}
\alias{getObjFunStarting}
\title{Retrieve GMWM starting value from Yannick's objective function}
\usage{
getObjFunStarting(theta, desc, objdesc, model_type, wv_empir, tau)
}
\arguments{
\item{theta}{A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters}

\item{desc}{A \code{vector<string>} indicating the models that should be considered.}

\item{objdesc}{A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))}

\item{model_type}{A \code{string} containing the model type. Either 'imu' or 'ssm'}

\item{wv_empir}{A \code{vec} containing the empirical wavelet variance.}

\item{tau}{A \code{vec} that contains the scales of 2^(1:J), where J is the number of scales created by the decomposition.}
}
\value{
A \code{double} that is the value of the Objective function under Yannick's starting algorithm
}
\description{
Obtains the GMWM starting value given by Yannick's objective function optimization
}
\keyword{internal}

