% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_ArchmSnB.R
\name{gofArchmSnB}
\alias{gofArchmSnB}
\title{The ArchmSnB test based on the Rosenblatt transformation for 
archimedean copula}
\usage{
gofArchmSnB(
  copula = c("clayton", "gumbel", "frank", "joe", "amh"),
  x,
  param = 0.5,
  param.est = TRUE,
  margins = "ranks",
  flip = 0,
  M = 1000,
  lower = NULL,
  upper = NULL,
  seed.active = NULL,
  processes = 1
)
}
\arguments{
\item{copula}{The copula to test for. Possible are \code{"clayton"}, 
\code{"gumbel"}, \code{"frank"}, \code{"joe"} and \code{"amh"}.}

\item{x}{A matrix containing the data with rows being observations and
columns being variables.}

\item{param}{The copula parameter to use, if it shall not be estimated.}

\item{param.est}{Shall be either \code{TRUE} or \code{FALSE}. \code{TRUE}
means that \code{param} will be estimated.}

\item{margins}{Specifies which estimation method for the margins shall be
used. The default is \code{"ranks"}, which is the standard approach to
convert data in such a case. Alternatively the following distributions can
be specified: \code{"beta"}, \code{"cauchy"}, Chi-squared (\code{"chisq"}),
\code{"f"}, \code{"gamma"}, Log normal (\code{"lnorm"}), Normal
(\code{"norm"}), \code{"t"}, \code{"weibull"}, Exponential (\code{"exp"}).
Input can be either one method, e.g. \code{"ranks"}, which will be used for
estimation of all data sequences. Also an individual method for each margin
can be specified, e.g. \code{c("ranks", "norm", "t")} for 3 data sequences.
If one does not want to estimate the margins, set it to \code{NULL}.}

\item{flip}{The control parameter to flip the copula by 90, 180, 270 degrees
clockwise. Only applicable for bivariate copula. Default is 0 and possible 
inputs are 0, 90, 180, 270 and NULL.}

\item{M}{Number of bootstrapping loops.}

\item{lower}{Lower bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{upper}{Upper bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{seed.active}{Has to be either an integer or a vector of M+1 integers.
If an integer, then the seeds for the bootstrapping procedure will be
simulated. If M+1 seeds are provided, then these seeds are used in the
bootstrapping procedure. Defaults to \code{NULL}, then \code{R} generates
the seeds from the computer runtime. Controlling the seeds is useful for
reproducibility of a simulation study to compare the power of the tests or
for reproducibility of an empirical study.}

\item{processes}{The number of parallel processes which are performed to
speed up the bootstrapping. Shouldn't be higher than the number of logical
processors. Please see the details.}
}
\value{
An object of the \code{class} gofCOP with the components
\item{method}{a character which informs about the performed analysis}
\item{copula}{the copula tested for} \item{margins}{the method used to
estimate the margin distribution.} \item{param.margins}{the parameters of
the estimated margin distributions. Only applicable if the margins were not
specified as \code{"ranks"} or \code{NULL}.} \item{theta}{dependence
parameters of the copulae} \item{df}{the degrees of freedem of the copula.
Only applicable for t-copula.} \item{res.tests}{a matrix with the p-values
and test statistics of the hybrid and the individual tests}
}
\description{
\code{\link{gofArchmSnB}} contains the SnB gof test with a Rosenblatt 
transformation for archimedean copulae, described in Hering and Hofert (2015).
The test follows the RosenblattChisq test as described in Genest (2009) 
and Hofert (2014), and compares the empirical copula against a parametric 
estimate of the copula derived under the null hypothesis. The margins can be 
estimated by a bunch of distributions and the time which is necessary for 
the estimation can be given. The approximate p-values are computed with a 
parametric bootstrap, which computation can be accelerated by enabling 
in-build parallel computation. The gof statistics are computed with the 
function \code{\link{gofTstat}} from the package copula. 
It is possible to insert datasets of all dimensions above 1 
(except for the \code{"amh"} copula) and the possible copulae are 
\code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"joe"} and 
\code{"amh"}. The parameter estimation is performed with pseudo maximum
likelihood method. In case the estimation fails, inversion of Kendall's tau
is used.
}
\details{
This test is based on the Rosenblatt transformation for archimedean copula
which uses the mapping \eqn{\mathcal{R}: (0,1)^d 
\rightarrow (0,1)^d}{R : (0,1)^d -> (0,1)^d}. Following 
Hering and Hofert (2015) the mapping provides 
pseudo observations \eqn{E_i}{E[i]}, given by \deqn{E_1 = \mathcal{R}(U_1), 
\dots, E_n = \mathcal{R}(U_n).}{E_1 = R(U_1), ..., E_n = R(U_n).} 
Let \eqn{C} be an Archimedean copula with \eqn{d} monotone generator 
\eqn{\psi} and continuous Kendall distribution function \eqn{K_{C}}. Then, 
\deqn{e_{j}=\left(\frac{\sum_{k=1}^{j} \psi^{-1}\left(u_{k}
\right)}{\sum_{k=1}^{j+1} \psi^{-1}\left(u_{k}\right)}\right)^{j}, 
j \in\{1, \ldots, d-1\}}{e[j] = (sum_k^(j)(\psi^(-1)(u_(k))) / 
sum_k^(j+1)(\psi^(-1)(u_(k))))^j, j = 1, ..., d-1} and 
\deqn{e_{d}= \frac{n}{n+1} K_{C}(C(u))}{e[i] = n / (n + 1) K(C(u))}. 
The resulting independence copula is given by
\eqn{C_{\bot}(\mathbf{u}) = u_1 \cdot \dots \cdot u_d}{Cind(u) = u[1] x ...
x u[d]}.

The test statistic \eqn{T} is then defined as

\deqn{T = n \int_{[0,1]^d} \{ D_n(\mathbf{u}) - C_{\bot}(\mathbf{u}) \}^2 d
(\mathbf{u})}{n int_{[0,1]^d} ( {Dn(u) - Cind(u)}^2 )du} with
\eqn{D_n(\mathbf{u}) = \frac{1}{n} \sum_{i = 1}^n \mathbf{I}(E_i \leq
\mathbf{u})}{Dn(u) = 1/n sum(E[i] <= u, i = 1, ..., n)}.

The approximate p-value is computed by the formula, see \pkg{copula},

\deqn{\sum_{b=1}^M \mathbf{I}(|T_b| \geq |T|) / M,}{sum(|T[b]| >= |T|, b=1,
.., M) / M,}

where \eqn{T} and \eqn{T_b}{T[b]} denote the test statistic and the
bootstrapped test statistc, respectively.

For small values of \code{M}, initializing the parallelisation via
\code{processes} does not make sense. The registration of the parallel
processes increases the computation time. Please consider to enable
parallelisation just for high values of \code{M}.
}
\examples{

data(IndexReturns2D)

gofArchmSnB("clayton", IndexReturns2D, M = 10)

}
\references{
Christian Genest, Bruno Remillard, David Beaudoin (2009).
Goodness-of-fit tests for copulas: A review and a power study.
\emph{Insurance: Mathematics and Economics, Volume 44, Issue 2, April 2009,
Pages 199-213, ISSN 0167-6687}.
\doi{10.1016/j.insmatheco.2007.10.005}\cr \cr Marius
Hofert, Ivan Kojadinovic, Martin Maechler, Jun Yan (2014). copula:
Multivariate Dependence with Copulas. \emph{R package version 0.999-15.}.
\url{https://cran.r-project.org/package=copula} \cr \cr
Christian Hering, Marius Hofert (2015) Goodness-of-fit tests for 
Archimedean copulas in high dimensions. \emph{In: Glau K., Scherer M., 
Zagst R. (eds) Innovations in Quantitative Risk Management, 
Springer Proceedings in Mathematics & Statistics, Volume 99, 
Springer, Cham, 357-373}.
\doi{10.1007/978-3-319-09114-3_21} \cr \cr
}
