% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgt.R
\name{hgt}
\alias{hgt}
\title{Calculate the hypergeometric tail}
\usage{
hgt(.b, N, B, .n)
}
\arguments{
\item{.b}{Number of annotations in target group}

\item{N}{Total number of articles}

\item{B}{Total number of annotations}

\item{.n}{Number of articles in target group}
}
\value{
P value of the hypergeometric distribution.
}
\description{
Given N articles, B of which are annotated to a given term, the chance that .b of these articles are annotated in a test set of size .n is equal to the hypergeometric tail function.
}
\details{
P value is computed as in referenced article (GOrilla). Briefly, the P value is the sum from .b to the minimum of .n and B of .n choose i plus N-.n choose B - i all divided by N choose B.
}
\references{
Eden, E., Navon, R., Steinfeld, I., Lipson, D., & Yakhini, Z. (2009). GOrilla: a tool for discovery and visualization of enriched GO terms in ranked gene lists. BMC Bioinformatics, 10(1), 1–7. http://doi.org/10.1186/1471-2105-10-48
}

