% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customization.R
\name{make_prep}
\alias{make_prep}
\title{Create a preparation function}
\usage{
make_prep(name, func)
}
\arguments{
\item{name}{Name of the preparation function.}

\item{func}{A function that takes two arguments:
The \code{path} to the root directory of the package, and
a logical argument: \code{quiet}. If \code{quiet} is true,
the preparation function may print out diagnostic messages.}
}
\description{
Create a preparation function
}
\examples{
# make a preparation function
url_prep <- make_prep(
  name = "desc", 
  func = function(path, quiet) desc::description$new(path)
)
# and the corresponding check function
url_chk <- make_check(
  description = "URL field in DESCRIPTION",
  tags = character(),
  preps = "desc",
  gp = "have a URL field in DESCRIPTION",
  check = function(state) state$desc$has_fields("URL")
)
# use together in gp()
bad1 <- system.file("bad1", package = "goodpractice")
res <- gp(bad1, checks = "no_description_depends",
          extra_preps = list("desc" = url_prep),
          extra_checks = list("url" = url_chk))
}
