% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_v4_get.R
\name{google_analytics_4}
\alias{google_analytics_4}
\title{GAv4 single request}
\usage{
google_analytics_4(viewId, date_range = NULL, metrics = NULL,
  dimensions = NULL, dim_filters = NULL, met_filters = NULL,
  filtersExpression = NULL, order = NULL, segments = NULL,
  pivots = NULL, cohorts = NULL, max = 1000,
  samplingLevel = c("DEFAULT", "SMALL", "LARGE"), metricFormat = NULL,
  histogramBuckets = NULL)
}
\arguments{
\item{viewId}{viewId of data to get.}

\item{date_range}{character or date vector of format \code{c(start, end)} or 
for two date ranges: \code{c(start1,end1,start2,end2)}}

\item{metrics}{Metric to fetch. Required. Supports calculated metrics.}

\item{dimensions}{Dimensions to fetch.}

\item{dim_filters}{A \link{filter_clause_ga4} wrapping \link{dim_filter}}

\item{met_filters}{A \link{filter_clause_ga4} wrapping \link{met_filter}}

\item{filtersExpression}{A v3 API style simple filter string. Not used with other filters.}

\item{order}{An \link{order_type} object}

\item{segments}{List of segments as created by \link{segment_ga4}}

\item{pivots}{Pivots of the data as created by \link{pivot_ga4}}

\item{cohorts}{Cohorts created by \link{make_cohort_group}}

\item{max}{Maximum number of rows to fetch. Defaults at 1000.}

\item{samplingLevel}{Sample level}

\item{metricFormat}{If supplying calculated metrics, specify the metric type}

\item{histogramBuckets}{For numeric dimensions such as hour, a list of buckets of data.
See details in \link{make_ga_4_req}}
}
\value{
A Google Analytics data.frame
}
\description{
A convenience function that wraps \link{make_ga_4_req} and \link{fetch_google_analytics_4}
 for the common case of one GA data request.
 
Will perform batching if over the 10000 row per API call limit.
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']

ga_data <- google_analytics_4(ga_id, 
                              date_range = c("2015-07-30","2015-10-01"),
                              dimensions=c('source','medium'), 
                              metrics = c('sessions','bounces'))

}

}
\seealso{
Other GAv4 fetch functions: \code{\link{fetch_google_analytics_4}},
  \code{\link{make_ga_4_req}}
}

