% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_data.R
\name{ga_data_aggregations}
\alias{ga_data_aggregations}
\title{Extract metric aggregations from a \link{ga_data} result}
\usage{
ga_data_aggregations(
  df,
  type = c("all", "totals", "maximums", "minimums", "count")
)
}
\arguments{
\item{df}{A data.frame result from \link{ga_data}}

\item{type}{totals, maximums, minimums, counts (if available) or all}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Metric aggregations are available in all requests.  This function lets you easily access the data.frames
}
\examples{

\dontrun{
#' # send up to 4 date ranges
multi_date <- ga_data(
  206670707,
  metrics = c("activeUsers","sessions"),
  dimensions = c("date","city","dayOfWeek"),
  date_range = c("2020-03-31", "2020-04-27", "2020-04-30", "2020-05-27"),
  dim_filters = ga_data_filter("city"=="Copenhagen"),
  limit = 100
  )

# metric aggregations for each date range
ga_data_aggregations(multi_date, type = "all")

# specify type
ga_data_aggregations(multi_date, type = "maximums")

}
}
