% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{cr_schedule}
\alias{cr_schedule}
\title{Creates or updates a Cloud Scheduler job.}
\usage{
cr_schedule(
  name,
  schedule = NULL,
  httpTarget = NULL,
  description = NULL,
  overwrite = FALSE,
  timeZone = Sys.timezone(),
  region = cr_region_get(),
  projectId = cr_project_get()
)
}
\arguments{
\item{name}{Optionally caller-specified in CreateJob, after}

\item{schedule}{A cron schedule e.g. \code{"15 5 * * *"}}

\item{httpTarget}{A HTTP target object \link{HttpTarget}}

\item{description}{Optionally caller-specified in CreateJob or}

\item{overwrite}{If TRUE and an existing job with the same name exists, will overwrite it with the new parameters}

\item{timeZone}{Specifies the time zone to be used in interpreting schedule. If set to \code{NULL} will be "UTC". Note that some time zones include a provision for daylight savings time.}

\item{region}{The region usually set with \link{cr_region_set}}

\item{projectId}{The GCP project to run within usually set with \link{cr_project_set}}
}
\value{
A \code{gar_scheduleJob} class object
}
\description{
Creates or updates a Cloud Scheduler job.
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_schedule("test",
      "* * * * *",
      httpTarget = HttpTarget(uri="https://code.markedmondson.me"))

# schedule a cloud build (no source)
build1 <- cr_build_make("cloudbuild.yaml")
cr_schedule("cloud-build-test", "15 5 * * *",
             httpTarget = cr_build_schedule_http(build1))

# schedule a cloud build with code source from GCS bucket
my_gcs_source <- cr_build_upload_gcs("my_folder", bucket = cr_get_bucket())
build <- cr_build_make("cloudbuild.yaml", source = my_gcs_source))
cr_schedule("cloud-build-test2", "15 5 * * *",
            httpTarget = cr_build_schedule_http(build))

# update a schedule with the same name - only supply what you want to change
cr_schedule("cloud-build-test2", "12 6 * * *", overwrite=TRUE)

# By default will use the timezone as specified by Sys.timezone() - change
# this by supplying it directly
cr_schedule("timzone-utc", "12 2 * * *", timeZone = "UTC")
}
}
\seealso{
\href{https://cloud.google.com/scheduler/docs/reference/rest/v1/projects.locations.jobs/create}{Google Documentation for Cloud Scheduler}

Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{Job}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()},
\code{\link{cr_schedule_run}()}
}
\concept{Cloud Scheduler functions}
