% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_admin.R
\name{cr_build_status}
\alias{cr_build_status}
\title{Returns information about a previously requested build.}
\usage{
cr_build_status(id = .Last.value, projectId = cr_project_get())
}
\arguments{
\item{id}{ID of the build or a \code{BuildOperationMetadata} object}

\item{projectId}{ID of the project}
}
\value{
A gar_Build object \link{Build} or NULL if not found
}
\description{
The `Build` that is returned includes its status (such as `SUCCESS`,`FAILURE`, or `WORKING`), and timing information.
}
\seealso{
\url{https://cloud.google.com/build/docs/api/reference/rest/v1/projects.builds#Build.Status}

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
