% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{cr_deploy_pkgdown}
\alias{cr_deploy_pkgdown}
\title{Deploy a cloudbuild.yml for a pkgdown website of an R package}
\usage{
cr_deploy_pkgdown(
  github_repo,
  secret,
  steps = NULL,
  create_trigger = c("file", "inline", "no"),
  cloudbuild_file = "cloudbuild-pkgdown.yml",
  git_email = "googlecloudrunner@r.com",
  env = NULL,
  build_image = "gcr.io/gcer-public/packagetools:latest",
  post_setup = NULL,
  post_clone = NULL
)
}
\arguments{
\item{github_repo}{The GitHub repo to deploy pkgdown website from and to.}

\item{secret}{The name of the secret on Google Secret Manager for the git ssh private key}

\item{steps}{extra steps to run before the pkgdown website steps run}

\item{create_trigger}{If not "no" then the buildtrigger will be setup for you via \link{cr_buildtrigger}, if "file" will create a buildtrigger pointing at \code{cloudbuild_file}, if "inline" will put the build inline within the trigger (no file created)}

\item{cloudbuild_file}{The cloudbuild yaml file to write to}

\item{git_email}{The email the git commands will be identifying as}

\item{env}{A character vector of env arguments to set for all steps}

\item{build_image}{A docker image with \code{pkgdown} installed}

\item{post_setup}{Steps that occur after git setup}

\item{post_clone}{A \link{cr_buildstep} that occurs after the repo is cloned}
}
\description{
This builds a pkgdown website each time the trigger fires and deploys it to git
}
\details{
The trigger repository needs to hold an R package configured to build a pkgdown website.

For GitHub, the repository will also need to be linked to the project you are building within, via \url{https://console.cloud.google.com/cloud-build/triggers/connect}

The git ssh keys need to be deployed to Google Secret Manager for the deployment of the website - see \link{cr_buildstep_git} - this only needs to be done once per Git account.
}
\examples{

pd <- cr_deploy_pkgdown("MarkEdmondson1234/googleCloudRunner",
  secret = "my_git_secret",
  create_trigger = "no"
)
pd
file.exists("cloudbuild-pkgdown.yml")
unlink("cloudbuild-pkgdown.yml")
\dontrun{
cr_deploy_pkgdown("MarkEdmondson1234/googleCloudRunner",
  secret = "my_git_secret",
  create_trigger = "inline"
)
}

}
\seealso{
Create your own custom deployment using \link{cr_buildstep_pkgdown} which this function uses with some defaults.

Other Deployment functions: 
\code{\link{cr_deploy_docker_trigger}()},
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_run_website}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
