% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisMap.R
\name{gvisMap}
\alias{gvisMap}
\title{Google Maps with R
\Sexpr{googleChartName <- "map"}
\Sexpr{gvisChartName <- "gvisMap"}}
\usage{
gvisMap(data, locationvar = "", tipvar = "", options = list(), chartid)
}
\arguments{
\item{data}{a \code{data.frame}. The data has to have at least two columns
with location name (\code{locationvar}) and the variable to display the text
in the tip icon (\code{tipvar}).}

\item{locationvar}{column name of \code{data} with the geo locations to be
analysed. The locations can be provide in two formats: \describe{
\item{Format 1}{'latitude:longitude'. See the example below.} \item{Format
2}{The first column should be a string that contains an address. This
address should be as complete as you can make it.  } }}

\item{tipvar}{column name of \code{data} with the string text displayed over
the tip icon.}

\item{options}{list of configuration options for Google Map.

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisMap function reads a data.frame and creates text output referring to
the Google Visualisation API, which can be included into a web page, or as a
stand-alone page.
}
\details{
The maps are the well known Google Maps.
}
\examples{

## Please note that by default the googleVis plot command
## will open a browser window and requires Internet
## connection to display the visualisation.
  
## Example with latitude and longitude information
## Plot Hurricane Andrew (1992) storm path:

data(Andrew)

M1 <- gvisMap(Andrew, "LatLong" , "Tip",
              options=list(showTip=TRUE, showLine=TRUE, enableScrollWheel=TRUE,
                           mapType='hybrid', useMapTypeControl=TRUE,
                           width=800,height=400))

plot(M1) 


## Example with address, here UK post-code and some html code in tooltip

df <- data.frame(Postcode=c("EC3M 7HA", "EC2P 2EJ"),
                 Tip=c("<a href='https://www.lloyds.com'>Lloyd's</a>", 
                 "<a href='https://www.guildhall.cityoflondon.gov.uk/'>Guildhall</a>"))
 
M2 <- gvisMap(df, "Postcode", "Tip",
              options=list(showTip=TRUE, mapType='normal',
              enableScrollWheel=TRUE))
 
plot(M2)

## Change mapping icons
M3 <- gvisMap(df, "Postcode", "Tip",
              options=list(showTip=TRUE, mapType='normal',
              enableScrollWheel=TRUE,
              icons=paste0("{",
              "'default': {'normal': 'https://icons.iconarchive.com/",
              "icons/icons-land/vista-map-markers/48/",
              "Map-Marker-Ball-Azure-icon.png',\n",
              "'selected': 'https://icons.iconarchive.com/",
              "icons/icons-land/vista-map-markers/48/",
              "Map-Marker-Ball-Right-Azure-icon.png'",
              "}}")))
                        
plot(M3)
}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for printing and
plotting methods, \code{\link{gvisGeoMap}} and
\code{\link{gvisIntensityMap}} for an alternative to \code{gvisMap}.
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\keyword{iplot}
