% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive_params.R
\name{team_drives}
\alias{team_drives}
\title{Access Team Drives}
\description{
How to capture a Team Drive or files/folders that live on a
Team Drive for downstream use:
\itemize{
\item \code{\link[=drive_find]{drive_find()}} and \code{\link[=drive_get]{drive_get()}} return a \code{\link{dribble}} with metadata on
files, including folders. Both can be directed to search on Team Drives,
using the optional arguments \code{team_drive} or \code{corpus} (documented below).
\item \code{\link[=team_drive_find]{team_drive_find()}} and \code{\link[=team_drive_get]{team_drive_get()}} return a \code{\link{dribble}} with
metadata on Team Drives themselves. You will need this in order to use a Team
Drive in certain file operations. For example, you can specify a Team Drive
as the parent folder via the \code{path} argument for upload, move, copy, etc.
}

Regard the functions above as the official "port of entry" for
Team Drives and Team Drive files and folders. Use them to capture your
target(s) in a \code{\link{dribble}} to pass along to other googledrive functions.
The general flexibility to refer to files by name, path, or id does not
apply to Team Drive files. While it's always a good idea to get things into
a \code{\link{dribble}} early, for Team Drives it's absolutely required.

Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.
}
\section{Specific Team Drive}{

To search one specific Team Drive, pass its name, marked id, or
\code{\link{dribble}} to \code{team_drive} somewhere in the call, like so:\preformatted{drive_find(..., team_drive = "i_am_a_team_drive_name")
drive_find(..., team_drive = as_id("i_am_a_team_drive_id"))
drive_find(..., team_drive = i_am_a_team_drive_dribble)
}

The value of \code{team_drive} is pre-processed with \code{\link[=as_team_drive]{as_team_drive()}}.
}

\section{Other collections}{

To search other collections, pass the \code{corpus} parameter somewhere in the
call, like so:\preformatted{drive_find(..., corpus = "user")
drive_find(..., corpus = "all")
drive_find(..., corpus = "domain")
}

Possible values of \code{corpus} and what they mean:
\itemize{
\item \code{"user"}: Queries files that the user has accessed, including both Team and
non-Team Drive files.
\item \code{"all"}: Queries files that the user has accessed and all Team Drives in
which they are a member. If you're reading the Drive API docs, this is a
googledrive convenience short cut for \code{"user,allTeamDrives"}.
\item \code{"domain"}: Queries files that are shared to the domain, including both
Team Drive and non-Team Drive files.
}
}

\section{API docs}{

googledrive implements Team Drive support as outlined here:
\itemize{
\item \url{https://developers.google.com/drive/v3/web/enable-teamdrives#including_team_drive_content_fileslist}
}

Users shouldn't need to know any of this, but here are details for the
curious. The extra information needed to search Team Drives consists of the
following query parameters:
\itemize{
\item \code{corpora}: Where to search? Formed from googledrive's \code{corpus} argument.
\item \code{teamDriveId}: The id of a specific Team Drive. Only allowed -- and also
absolutely required -- when \code{corpora = "teamDrive"}. When user specifies a
Team Drive, googledrive sends its id and also infers that \code{corpora} should
be set to \code{"teamDrive"} and sent.
\item \code{includeTeamDriveItems}: Do you want to see Team Drive items? Obviously,
this should be \code{TRUE} and googledrive sends this whenever Team Drive
parameters are detected
\item \code{supportsTeamDrives}: Does the sending application (googledrive, in this
case) know about Team Drives? Obviously, this should be \code{TRUE} and
googledrive sends it for all applicable endpoints, all the time.
}
}

