% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_about.R
\name{drive_about}
\alias{drive_about}
\title{Get info on Drive capabilities}
\usage{
drive_about()
}
\value{
A list representation of a Drive
\href{https://developers.google.com/drive/v3/reference/about#resource}{about resource}
}
\description{
Gets information about the user, the user's Drive, and system capabilities.
This function mostly exists to power \code{\link[=drive_user]{drive_user()}}, which extracts the most
useful information (the information on current user) and prints it nicely.
}
\examples{
\dontrun{
drive_about()

## explore the names of available Team Drive themes
about <- drive_about()
about[["teamDriveThemes"]] \%>\%
  purrr::map_chr("id")
}
}
\seealso{
Wraps the \code{about.get} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/about/get}
}
}
