% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_rename.R
\name{sheet_rename}
\alias{sheet_rename}
\title{Rename a (work)sheet}
\usage{
sheet_rename(ss, sheet = NULL, new_name)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to rename, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. Defaults to the first visible sheet.}

\item{new_name}{New name of the sheet, as a string. This is required.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Changes the name of a (work)sheet.
}
\examples{
if (gs4_has_token()) {
  ss <- gs4_create(
    "sheet-rename-demo",
    sheets = list(iris = head(iris), chickwts = head(chickwts))
  )
  sheet_names(ss)

  ss \%>\%
    sheet_rename(1, new_name = "flowers") \%>\%
    sheet_rename("chickwts", new_name = "poultry")

  # clean up
  gs4_find("sheet-rename-demo") \%>\%
    googledrive::drive_trash()
}
}
\seealso{
Makes an \code{UpdateSheetPropertiesRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#UpdateSheetPropertiesRequest}
}

Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_append}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
