% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_make.R
\name{request_make}
\alias{request_make}
\title{Make a Google Sheets API request}
\usage{
request_make(x, ..., encode = "json")
}
\arguments{
\item{x}{List. Holds the components for an HTTP request, presumably created
with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_develop]{gargle::request_build()}}. Must contain a
\code{method} and \code{url}. If present, \code{body} and \code{token} are used.}

\item{...}{Optional arguments passed through to the HTTP method.}

\item{encode}{If the body is a named list, how should it be encoded? This has
the same meaning as \code{encode} in all the \code{\link[httr:VERB]{httr::VERB()}}s, such as
\code{\link[httr:POST]{httr::POST()}}. Note, however, that we default to \code{encode = "json"}, which
is what you want most of the time when calling the Sheets API. The httr
default is \code{"multipart"}. Other acceptable values are \code{"form"} and \code{"raw"}.}
}
\value{
Object of class \code{response} from \link{httr}.
}
\description{
Low-level function to execute a Sheets API request. Most users should,
instead, use higher-level wrappers that facilitate common tasks, such as
reading or writing worksheets or cell ranges. The functions here are intended
for internal use and for programming around the Sheets API.
}
\details{
\code{make_request()} is a very thin wrapper around \code{\link[gargle:request_retry]{gargle::request_retry()}},
only adding the googlesheets4 user agent. Typically the input has been
created with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_develop]{gargle::request_build()}} and the output
is processed with \code{process_response()}.

\code{\link[gargle:request_retry]{gargle::request_retry()}} retries requests that error with \verb{429 RESOURCE_EXHAUSTED}. Its basic scheme is exponential backoff, with one tweak
that is very specific to the Sheets API, which has documented \href{https://developers.google.com/sheets/api/limits}{usage limits}:

"a limit of 500 requests per 100 seconds per project and 100 requests per 100
seconds per user"

Note that the "project" here means everyone using googlesheets4 who hasn't
configured their own OAuth app. This is potentially a lot of users, all
acting independently.

If you hit the "100 requests per 100 seconds per \strong{user}" limit (which
really does mean YOU), the first wait time is a bit more than 100 seconds,
then we revert to exponential backoff.

If you experience lots of retries, especially with 100 second delays, it
means your use of googlesheets4 is more than casual and \strong{it's time for you
to get your own OAuth app or use a service account token}. This is explained
in the gargle vignette \code{vignette("get-api-credentials", package = "gargle")}.
}
\seealso{
Other low-level API functions: 
\code{\link{gs4_has_token}()},
\code{\link{gs4_token}()},
\code{\link{request_generate}()}
}
\concept{low-level API functions}
