% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{compute_path_distance}
\alias{compute_path_distance}
\title{Compute the distance of a TSP path}
\usage{
compute_path_distance(h, d)
}
\arguments{
\item{h}{A path specified by a vertex sequence}

\item{d}{Distance matrix to use}
}
\value{
The path distance \deqn{d(\{v_1,...,v_n\}) = \sum_{j=1}^{n-1}
    d(v_j,v_{j + 1}).}
}
\description{
It computes the distance covered by a path in a Traveling Salesman Problem
}
\details{
This function simply add the distances in a distance matrix
indicated by a vertex sequence defining a path.  It takes into
account that, in a path, the last vertex is \strong{not}
joined to the first one by an edge, unlike \link{compute_tour_distance}.
}
\examples{
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)
h <- sample(1:n)              # A random tour
compute_path_distance(h, d)   # 107.246
compute_tour_distance(h, d) - compute_path_distance(h, d) - d[h[1], h[n]]

}
\seealso{
\link{build_tour_nn} nearest neighbor heuristic with a single
starting point, \link{build_tour_nn_best} repeats the previous
algorithm with all possible starting points,
\link{compute_distance_matrix} computes a distance matrix,
\link{compute_tour_distance} computes tour distances, \link{plot_tour}
plots a tour.
}
\author{
Cesar Asensio
}
