% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{is_cover}
\alias{is_cover}
\title{Check vertex cover}
\usage{
is_cover(X, eG)
}
\arguments{
\item{X}{Vertex subset to check.}

\item{eG}{Edgelist of the graph as returned by \link{as_edgelist}}
}
\value{
Boolean: TRUE if X is a vertex cover of the graph
represented by eG, FALSE otherwise.
}
\description{
Check if some vertex subset of a graph covers all its edges.
}
\details{
The routine simply goes through the edge list of the graph to see
if both ends of each edge are inside the vertex subset to be
checked.  When an edge with both ends ouside X is
encountered, the routine returns FALSE; otherwise, it returns
TRUE.
}
\examples{
set.seed(1)
n <- 25
g <- sample_gnp(n, p=0.25)  # Random graph
eg <- as_edgelist(g)

X1 <- build_cover_greedy(g)
is_cover(X1$set, eg)   # TRUE
is_cover(c(1:10),eg)   # FALSE
plot_cover(list(set = 1:10, size = 10), g)  # See uncovered edges

}
\seealso{
\link{build_cover_greedy} builds a cover using a greedy heuristic,
\link{build_cover_approx} builds a cover using a 2-approximation
algorithm, \link{improve_cover_flip} improves a cover using local
search, \link{search_cover_random} looks for a random cover of
fixed size, \link{search_cover_ants} looks for a random cover using
a version of the ant-colony optimization heuristic,
\link{find_cover_BB} finds covers using a branch-and-bound
technique, \link{plot_cover} plots a cover.
}
\author{
Cesar Asensio
}
