#' Reading achievement data
#'
#' Dataset based on Finch, Bolin, and Kelley (2014, p.32).
#'
#' \tabular{lll}{
#'   \strong{school} \tab \code{integer} \tab Clustering variable representing
#'   the school a given participant was enrolled in\cr
#'   \strong{gender} \tab \code{factor} \tab Binary factor variable representing
#'   participants' assigned sex\cr
#'   \strong{age} \tab \code{integer} \tab Participants' age in months\cr
#'   \strong{geread} \tab \code{numeric} \tab Reading achievement\cr
#'   \strong{gevocab} \tab \code{numeric} \tab Vocabulary
#' }
#' @docType data
#' @keywords datasets
#' @name reading_ach
#' @usage data(reading_ach)
#' @references Finch, W. H., Bolin, J. E., & Kelley, K. (2014). Multilevel
#' modeling using r. CRC Press 2014.
#' @format A data frame with 10320 rows and 5 variables.
NULL
