% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_binomial.R
\name{rank_binomial}
\alias{rank_binomial}
\title{Binary rankings from pairwise contests}
\usage{
rank_binomial(object, drop.null = FALSE, disaggregate = FALSE)
}
\arguments{
\item{object}{an object of class \code{rankings}, \code{grouped_rankings}
or \code{paircomp}}

\item{drop.null}{logical, an optional argument to remove null contests}

\item{disaggregate}{logical, if \code{TRUE} binaries are disaggregated 
by individual contests}
}
\value{
A data.frame with binary rank of pairwise contests:
\item{player1}{a factor with n levels for the first player 
 in the contests}
\item{player2}{a factor with n levels (same as player1) for 
 the second player in the contests}
\item{win1}{number of times player1 wins against player2}
\item{win2}{number of times player2 wins against player1}
}
\description{
Binary comparisons from a ranking object. Ties are not 
taken into account, then they are added as NA's.
}
\examples{
library("PlackettLuce")

R = matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 4, 3, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) = c("apple", "banana", "orange", "pear")

R = as.rankings(R)

rank_binomial(R)

rank_binomial(R, disaggregate = TRUE)

}
\references{
Turner H. & Firth D. (2012). 
Journal of Statistical Software, 48(9), 1–21. 
\doi{https://doi.org/10.18637/jss.v048.i09}
}
\seealso{
Other rank functions: 
\code{\link{rank_numeric}()},
\code{\link{rank_paircomp}()},
\code{\link{rank_tricot}()}
}
\author{
Kauê de Sousa
}
\concept{rank functions}
