% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dde.R
\name{inneropt.DDE}
\alias{inneropt.DDE}
\title{Inner optimization for estmating coefficients given parameters.}
\usage{
inneropt.DDE(data, times, pars, beta, coefs, lik, proc, in.meth = "nlminb",
  control.in = list(), basisvals, fdobj0)
}
\arguments{
\item{data}{Matrix of observed data values.}

\item{times}{Vector observation times for the data.}

\item{pars}{Initial values of parameters to be estimated processes.}

\item{beta}{Initial values of the contribution of lags for the delay.}

\item{coefs}{Vector giving the current estimate of the coefficients in the spline.}

\item{lik}{\code{lik} object defining the observation process.}

\item{proc}{\code{proc} object defining the state process.}

\item{in.meth}{Inner optimization function currently one of \code{'nlminb'}, \code{'optim'}, or \code{'trustOptim'}.}

\item{control.in}{Control object for inner optimization function.}

\item{basisvals}{Values of the collocation basis to be used. This should be a basis object from the fda package.}

\item{fdobj0}{A functional data object fitted with the history part of the data.}
}
\value{
A list with elements
\describe{
    \item{coefs}{A matrix giving he optimized coefficients.}
    \item{res}{The results of the inner optimization function.}
}
}
\description{
Estmates spline coefficients given parameters for DDE models.
}
\details{
This minimizes the objective function for DDE models defined by the addition of the \code{lik} and \code{proc} objectives with respect to the coefficients. A number of generic optimization routines can be used and some experimentation is recommended.
}
\author{
Ziqian Zhou
}

