% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateRead}
\alias{generateRead}
\title{Generate a noisy read from a true sequence.}
\usage{
generateRead(seq = "ATGCGGATCG", qv = NULL, seed = NULL,
  paramgphmm = initializeGphmm())
}
\arguments{
\item{seq}{- character vector of true sequence.}

\item{qv}{- integer, wanted phred quality score for the read.}

\item{seed}{- integer, seed for reproducibility.}

\item{paramgphmm}{- list of parameters.}
}
\description{
\code{generateRead} returns a list with the noisy read, the true sequence, the path, and the phred quality score.
}
\examples{
generateRead('ACGTGCA')
generateRead('ACGTGCA', qv = 10, seed = 1416)
}
