% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-view.R
\name{gpkg_create_spatial_view}
\alias{gpkg_create_spatial_view}
\title{Create a Spatial View}
\usage{
gpkg_create_spatial_view(
  g,
  viewname,
  viewquery,
  geom_column = "geom",
  geometry_type_name = "GEOMETRY",
  spatialite_computed = FALSE,
  data_type = "features",
  srs_id = 4326,
  z = 0,
  m = 0
)
}
\arguments{
\item{g}{a \code{geopackage}}

\item{viewname}{\emph{character}. Name of view.}

\item{viewquery}{\emph{character}. Query for view contents.}

\item{geom_column}{\emph{character}. Column name of view geometry. Default: \code{"geom"}}

\item{geometry_type_name}{\emph{character}. View geometry type. Default: \code{"GEOMETRY"}}

\item{spatialite_computed}{\emph{logical}. Register definition of \code{geom_column} as
the result of a Spatialite spatial function via
\code{"gdal_spatialite_computed_geom_column"} extension.
Default: \code{FALSE}}

\item{data_type}{\emph{character}. View data type. Default \code{"features"}}

\item{srs_id}{\emph{integer}. Spatial Reference System ID. Default: \code{4326} (WGS84)}

\item{z}{\emph{integer}. Default: \code{0}}

\item{m}{\emph{integer}. Default: \code{0}}
}
\value{
\emph{integer}. Returns \code{1} if a new record in \code{gpkg_geometry_columns} is successfully made.
}
\description{
Create a Spatial View
}
