% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_optim.R
\name{gp_optim}
\alias{gp_optim}
\title{Optimize hyperparameters of a GP model}
\usage{
gp_optim(
  gp,
  x,
  y,
  tol = 1e-04,
  maxiter = 500,
  verbose = TRUE,
  warnings = TRUE,
  ...
)
}
\arguments{
\item{gp}{The gp model object to be fitted.}

\item{x}{n-by-d matrix of input values (n is the number of observations and d the input
dimension). Can also be a vector of length n if the model has only a single input.}

\item{y}{Vector of n output (target) values.}

\item{tol}{Relative change in the objective function value after which the optimization is
terminated.}

\item{maxiter}{Maximum number of iterations.}

\item{verbose}{If TRUE, then some information about the progress of the optimization is
printed to the console.}

\item{warnings}{Whether to print out some potential warnings (such as maximum number of
iterations reached) during the optimization.}

\item{...}{Further arguments to be passed to \code{\link{gp_fit}} that are needed
in the fitting process, for example \code{trials} in the case of binomial likelihood.}
}
\value{
An updated GP model object.
}
\description{
This function can be used to optimize the hyperparameters of the model to the maximum
marginal likelihood (or maximum marginal posterior if priors are used), using Nelder-Mead
algorithm.
}
\section{References}{


Rasmussen, C. E. and Williams, C. K. I. (2006). Gaussian processes for machine learning. MIT Press.
}

\examples{

# Generate some toy data
set.seed(1242)
n <- 50
x <- matrix(rnorm(n * 3), nrow = n)
f <- sin(x[, 1]) + 0.5 * x[, 2]^2 + x[, 3]
y <- f + 0.5 * rnorm(n)
x <- data.frame(x1 = x[, 1], x2 = x[, 2], x3 = x[, 3])

# Basic usage
cf <- cf_sexp()
lik <- lik_gaussian()
gp <- gp_init(cf, lik)
gp <- gp_optim(gp, x, y)


}
