#' List of hexcodes of colours in grafify palettes
#' 
#' To visualise these colours use \code{plot_grafify_palette}. `okabe_ito`, `bright`, `contrast`, `dark`, `light`, `muted`, `pale`, `vibrant`, `yello_conti` from Paul Tol's [post](https://personal.sron.nl/~pault/). Zesty, Pastel, Elegant from this [link](https://venngage.com/blog/color-blind-friendly-palette/). Colour hexcodes for `fishy`, `kelly`, `r4`, `safe`, `OrBl_div`, `PrGn_div`, `blue_conti`, `grey_conti` taken from [cols4all:c4a_gui](https://github.com/mtennekes/cols4all) package. All schemes are colour blind-friendly.
#' 
#' @return This is a character vector with names and hexcodes of colours used by palette functions. It is used by \code{get_graf_colours} to generate palettes.
#' 
#' @export
graf_colours <- c('ok_orange' = "#E69F00",
                  'ok_skyblue' = "#56B4E9",
                  'ok_bluegreen' = "#009E73",
                  'ok_yellow' = "#F0E442",
                  'ok_blue' = "#0072B2",
                  'ok_vermillion' = "#D55E00",
                  'ok_redpurple' = "#CC79A7",
                  'ok_grey' = "#999999",
                  'bright_blue' ="#4477aa",
                  'bright_cyan' = "#66ccee",
                  'bright_green' = "#228833",
                  'bright_yellow' = "#ccbb44",
                  'bright_red' = "#ee6677",
                  'bright_purple' = "#aa3377",
                  'bright_grey' = "#bbbbbb",
                  'muted_indigo' ="#332288",
                  'muted_cyan' = "#88ccee",
                  'muted_teal' = "#44aa99",
                  'muted_green' = "#117733",
                  'muted_olive' = "#999933",
                  'muted_sand' = "#ddcc77",
                  'muted_rose' = "#cc6677",
                  'muted_wine' = "#882255",
                  'muted_purple' = "#aa4499",
                  'pale_grey' = "#dddddd",
                  'pale_blue' ="#bbccee",
                  'pale_cyan' = "#cceeff",
                  'pale_green' = "#ccddaa",
                  'pale_yellow' = "#eeeebb",
                  'pale_red' = "#ffcccc",
                  'dark_blue' ="#222255",
                  'dark_cyan' = "#225555",
                  'dark_green' = "#225522",
                  'dark_yellow' = "#666633",
                  'dark_red' = "#663333",
                  'dark_grey' = "#555555",
                  'light_blue' ="#77aadd",
                  'light_cyan' = "#99ddff",
                  'light_mint' = "#44bb99",
                  'light_pear' = "#bbcc33",
                  'light_olive' = "#aaaa00",
                  'light_yellow' = "#eedd88",
                  'light_orange' = "#ee8866",
                  'light_pink' = "#ffaabb",
                  'vibrant_blue' = "#0077bb",
                  'vibrant_cyan' = "#33bbee",
                  'vibrant_teal' = "#009988",
                  'vibrant_orange' = "#ee7733",
                  'vibrant_red' = "#cc3311",
                  'vibrant_magenta' = "#ee3377",
                  'contrast_white' = "#ffffff",
                  'contrast_yellow' = "#ddaa33",
                  'contrast_red' = "#bb5566",
                  'contrast_blue' = "#004488",
                  'contrast_black' = "#000000",
                  'YlOrBr_1' = "#FFFFE5",
                  'YlOrBr_2' = "#FFF7BC",
                  'YlOrBr_3' = "#FEE391",
                  'YlOrBr_4' = "#FEC44F",
                  'YlOrBr_5' = "#FB9A29", 
                  'YlOrBr_6' = "#EC7014",
                  'YlOrBr_7' = "#CC4C02",
                  'YlOrBr_8' = "#993404",
                  'YlOrBr_9' = "#662506",
#                  'zesty_orange' = "#F5793A",
#                  'zesty_purple' = "#A95AA1",
#                  'zesty_skyblue' = "#85C0F9",
#                  'zesty_blue' = "#0F2080",
#                  'pastel_brown' = "#BDB8AD",
#                  'pastel_cream' = "#EBE7E0",
#                  'pastel_skyblue' = "#C6D4E1",
#                  'pastel_blue' = "#44749D",
#                  'elegant_green' = "#ABC3C9",
#                  'elegant_cream' = "#E0DCD3",
#                  'elegant_bush' = "#CCBE9F",
#                  'elegant_brown' = '#382119',
                  'safe_blue' = "#88CCEE",
                  'safe_red' = "#CC6677", 
                  'safe_yellow' = "#DDCC77",
                  'safe_green' = "#117733",
                  'safe_violet' = "#332288",
                  'safe_purple' = "#AA4499", 
                  'safe_bluegreen' = "#44AA99",
                  'safe_bush' = "#999933",
                  'safe_reddish' = "#882255",
                  'safe_wine' = "#661100",
                  'safe_skyblue' = "#6699CC",
                  'kelly_1' = "#F3C300",
                  'kelly_2' = "#875692",
                  'kelly_3' = "#F38400",
                  'kelly_4' = "#A1CAF1",
                  'kelly_5' = "#BE0032",
                  'kelly_6' = "#C2B280",
                  'kelly_7' = "#848482",
                  'kelly_8' = "#008856",
                  'kelly_9' = "#E68FAC",
                  'kelly_10' = "#0067A5",
                  'kelly_11' = "#F99379",
                  'kelly_12' = "#604E97",
                  'kelly_13' = "#F6A600",
                  'kelly_14' = "#B3446C",
                  'kelly_15' = "#DCD300",
                  'kelly_16' = "#882D17",
                  'kelly_17' = "#8DB600",
                  'kelly_18' = "#654522",
                  'kelly_19' = "#E25822",
                  'kelly_20' = "#2B3D26",
#                  'rainbow_1' = "#E8ECFB",
#                  'rainbow_2' = "#D9CCE3",
#                  'rainbow_3' = "#CAACCB",
#                  'rainbow_4' = "#BA8DB4",
#                  'rainbow_5' = "#AA6F9E",
#                  'rainbow_6' = "#994F88",
#                  'rainbow_7' = "#882E72",
#                  'rainbow_8' = "#1965B0",
#                  'rainbow_9' = "#437DBF",
#                  'rainbow_10' = "#6195CF",
#                  'rainbow_11' = "#7BAFDE",
#                  'rainbow_12' = "#4EB265",
#                  'rainbow_13' = "#90C987",
#                  'rainbow_14' = "#CAE0AB",
#                  'rainbow_15' = "#F7F056",
#                  'rainbow_16' = "#F7CB45",
#                  'rainbow_17' = "#F4A736",
#                  'rainbow_18' = "#EE8026",
#                  'rainbow_19' = "#E65518",
#                  'rainbow_20' = "#DC050C",
#                  'rainbow_21' = "#A5170E",
#                  'rainbow_22' = "#72190E",
#                  'rainbow_23' = "#42150A",
                  'r4_1' = "#DF536B",
                  'r4_2' = "#61D04F",
                  'r4_3' = "#2297E6",
                  'r4_4' = "#28E2E5",
                  'r4_5' = "#CD0BBC",
                  'r4_6' = "#F5C710",
                  'fishy_1' = "#6388b4",
                  'fishy_2' = "#ffae34",
                  'fishy_3' = "#ef6f6a",
                  'fishy_4' = "#8cc2ca",
                  'fishy_5' = "#c3bc3f",
                  'fishy_6' = "#55ad89",
                  'fishy_7' = "#bb7693",
                  'fishy_8' = "#baa094",
                  'fishy_9' = "#767676",
#                  'milly_1' = "#4f6980",
#                  'milly_2' = "#849db1",
#                  'milly_3' = "#a2ceaa",
#                  'milly_4' = "#638b66",
#                  'milly_5' = "#bfbb60",
#                  'milly_6' = "#f47942",
#                  'milly_7' = "#fbb04e",
#                  'milly_8' = "#b66353",
#                  'milly_9' = "#d7ce9f",
#                  'milly_10' = "#b9aa97",
#                  'winter_1' = "#90728f",
#                  'winter_2' = "#b9a0b4", 
#                  'winter_3' = "#9d983d",
#                  'winter_4' = "#cecb76",
#                  'winter_5' = "#e15759", 
#                  'winter_6' = "#ff9888",
#                  'winter_7' = "#6b6b6b",
#                  'winter_8' = "#aa8780", 
#                  'winter_9' = "#dab6af",
                  'grey_lin1' = "#F1F1F1",
                  'grey_lin2' = "#D8D8D8",
                  'grey_lin3' = "#C0C0C0",
                  'grey_lin4' = "#A9A9A9",
                  'grey_lin5' = "#929292",
                  'grey_lin6' = "#7D7D7D",
                  'grey_lin7' = "#676767",
                  'grey_lin8' = "#535353",
                  'grey_lin9' = "#3F3F3F",
                  'grey_lin10' = "#2C2C2C",
                  'grey_lin11' = "#1A1A1A",
                  'blue_1' = "#F8F8F8",
                  'blue_2' = "#E5F1FF",
                  'blue_3' = "#D0E4FF",
                  'blue_4' = "#B6D2F8",
                  'blue_5' = "#99BFEE",
                  'blue_6' = "#79ABE1",
                  'blue_7' = "#5294D3",
                  'blue_8' = "#027EC4",
                  'blue_9' = "#0066A5",
                  'blue_10' = "#004C85",
                  'blue_11' = "#00356C",
                  'PrGn_1' = "#762A83",
                  'PrGn_2' = "#9262A2",
                  'PrGn_3' = "#B18FC0",
                  'PrGn_4' = "#D0B7D8",
                  'PrGn_5' = "#EADAEB",
                  'PrGn_6' = "#F7F7F7",
                  'PrGn_7' = "#DFF1DA",
                  'PrGn_8' = "#BEDEB2",
                  'PrGn_9' = "#8CC485",
                  'PrGn_10' = "#4EA258",
                  'PrGn_11' = "#1A7837",
                  'OrBl_1' = "#9E3D21",
                  'OrBl_2' = "#BE4E21",
                  'OrBl_3' = "#DA6524",
                  'OrBl_4' = "#EF8530",
                  'OrBl_5' = "#F0AC72",
                  'OrBl_6' = "#D8D4C9",
                  'OrBl_7' = "#A2BCCF",
                  'OrBl_8' = "#6FA3CB",
                  'OrBl_9' = "#5789B6",
                  'OrBl_10' = "#4071A0",
                  'OrBl_11' = "#2B5B8A"
)
