% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{f.old.equi}
\alias{f.old.equi}
\alias{f.old.nonequi}
\alias{f.new}
\title{Functions to compute the abundance of new or old RNA at time t.}
\usage{
f.old.equi(t, s, d)

f.old.nonequi(t, f0, s, d)

f.new(t, s, d)
}
\arguments{
\item{t}{time in h}

\item{s}{synthesis date in U/h (arbitrary unit U)}

\item{d}{degradation rate in 1/h}

\item{f0}{the abundance at time t=0}
}
\value{
the RNA abundance at time t
}
\description{
The standard mass action kinetics model of gene expression arises from the differential equation
\eqn{df/dt = s - d  f(t)}, with s being the constant synthesis rate, d the constant degradation rate and \eqn{f0=f(0)} (the abundance at time 0).
}
\section{Functions}{
\itemize{
\item \code{f.old.equi()}: abundance of old RNA assuming steady state (i.e. f0=s/d)

\item \code{f.old.nonequi()}: abundance of old RNA without assuming steady state

\item \code{f.new()}: abundance of new RNA (steady state does not matter)

}}
\examples{
 d=log(2)/2
 s=10

 f.new(2,s,d)  # Half-life 2, so after 2h the abundance should be half the steady state
 f.old.equi(2,s,d)
 s/d

 t<-seq(0,10,length.out=100)
 plot(t,f.new(t,s,d),type='l',col='blue',ylim=c(0,s/d))
 lines(t,f.old.equi(t,s,d),col='red')
 abline(h=s/d,lty=2)
 abline(v=2,lty=2)
 # so old and new RNA are equal at t=HL (if it is at steady state at t=0)

 plot(t,f.new(t,s,d),type='l',col='blue')
 lines(t,f.old.nonequi(t,f0=15,s,d),col='red')
 abline(h=s/d,lty=2)
 abline(v=2,lty=2)
 # so old and new RNA are not equal at t=HL (if it is not at steady state at t=0)

}
\concept{kinetics}
