% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_node_metric.R
\name{compute_node_metric}
\alias{compute_node_metric}
\title{Compute graph-theoretic metrics from a graph at the node level}
\usage{
compute_node_metric(
  graph,
  metrics = c("deg", "close", "btw", "str", "siw", "miw"),
  weight = TRUE
)
}
\arguments{
\item{graph}{An object of class \code{igraph}. Its nodes must have names.}

\item{metrics}{Character vector specifying the graph-theoretic
metrics computed at the node-level in the graphs
Graph-theoretic metrics can be:
\itemize{
\item{Degree (\code{metrics = c("deg", ...)})}
\item{Closeness centrality index (\code{metrics = c("close",...)})}
\item{Betweenness centrality index (\code{metrics = c("btw",...)})}
\item{Strength (sum of the weights of the links connected to a node)
(\code{metrics = c("str",...)})}
\item{Sum of the inverse weights of the links connected to a
node (\code{metrics = c("siw", ...)}, default)}
\item{Mean of the inverse weights of the links connected to a
node (\code{metrics = c("miw", ...)})}
}
By default, the vector \code{metrics} includes all these metrics.}

\item{weight}{Logical which indicates whether the links are weighted during
the calculation of the centrality indices betweenness and closeness.
(default: \code{weight = TRUE}). Link weights are interpreted as distances
when computing the shortest paths. They should then be inversely proportional
to the strength of the relationship between nodes (e.g. to fluxes).}
}
\value{
A \code{data.frame} with the node names and the metrics computed.
}
\description{
The function computes graph-theoretic metric values at the
node level.
}
\examples{
data(data_ex_genind)
mat_gen <- mat_gen_dist(x = data_ex_genind, dist = "DPS")
graph <- gen_graph_thr(mat_w = mat_gen, mat_thr = mat_gen,
                            thr = 0.8)
res_met <- compute_node_metric(graph)
}
\author{
P. Savary
}
