% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_modul.R
\name{graphab_modul}
\alias{graphab_modul}
\title{Create modules from a graph in the Graphab project}
\usage{
graphab_modul(
  proj_name,
  graph,
  dist,
  prob = 0.05,
  beta = 1,
  nb = NULL,
  return = TRUE,
  proj_path = NULL,
  alloc_ram = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{graph}{A character string indicating the name of the graph on which
the modularity index is computed. This graph has been created with Graphab
or using \code{\link{graphab_graph}} function and is associated
with a link set. Only the links present in the graph and their corresponding
weights will be used in the computation, together with patch areas.}

\item{dist}{A numeric or integer value specifying the distance at which
dispersal probability is equal to \code{prob}. This argument is mandatory
for weighted metrics (PC, F, IF, BC, dPC, CCe, CF) but not used for others.
It is used to set \eqn{\alpha} for computing dispersal probabilities associated
with all inter-patch distances such that dispersal probability between
patches i and j is \eqn{p_{ij}= e^{-\alpha d_{ij}}}.}

\item{prob}{A numeric or integer value specifying the dispersal probability
at distance \code{dist}. By default, \code{code=0.05}. It is used to set
\eqn{\alpha} (see param \code{dist} above).}

\item{beta}{A numeric or integer value between 0 and 1 specifying the
exponent associated with patch areas in the computation of metrics
weighted by patch area. By default, \code{beta=1}. When \code{beta=0}, patch
areas do not have any influence in the computation.}

\item{nb}{(optional, default=NULL) An integer or numeric value indicating
the number of modules to be created. By default, it is the number that
maximises the modularity index.}

\item{return}{Logical (default=TRUE) indicating whether results are returned
to user.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}
}
\value{
If \code{return=TRUE}, the function returns a message indicating
whether the partition has been done. New options are being developed.
}
\description{
The function creates modules from a graph by maximising
modularity
}
\details{
This function maximises a modularity index by searching for the
node partition involves a large number of links within modules and a small
number of inter-module links. Each link is given a weight in the computation,
such as the weight \eqn{w_{ij}} of the link between patches i and j is:
\deqn{w_{ij} = (a_{i} a_{j})^\beta e^{-\alpha d_{ij}}}.
This function does not allow users to convert automatically Euclidean
distances into cost-distances.
See more information in Graphab 2.8 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.8-en.pdf}
}
\examples{
\dontrun{
graphab_modul(proj_name = "grphb_ex",
               graph = "graph",
               dist = 1000,
               prob = 0.05,
               beta = 1)
}
}
\author{
P. Savary
}
