% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_sampling.R
\name{prior_sampling}
\alias{prior_sampling}
\title{Sample The Precision Matrix}
\usage{
prior_sampling(
  p,
  burnin,
  nmc,
  prior_name = c("BGL", "GHS", "G_Wishart"),
  G = NULL,
  V = NULL,
  alpha = NULL,
  lambda = NULL
)
}
\arguments{
\item{p}{The dimension of the precision matrix that will be sampled}

\item{burnin}{The number of iterations the MCMC sampler should iterate 
through and discard before beginning to save results}

\item{nmc}{The number of samples that will be drawn}

\item{prior_name}{The name of the prior for which the marginal should be 
calculated, this is one of 'Wishart', 'BGL', 'GHS', 'G_Wishart'}

\item{G}{The adjacency matrix when specifying 'G_Wishart' prior}

\item{V}{The scale matrix when specifying 'Wishart' or 'G_Wishart' prior}

\item{alpha}{A number specifying alpha for the priors of 'Wishart' and 
'G_Wishart'}

\item{lambda}{A number specifying lambda for the priors of 'BGL' and 'GHS'
prior}
}
\value{
An array of dim nmc x p x p where each p x p slice is one sample of 
the precision matrix
}
\description{
Takes specified prior_name and relevant parameters to sample the precision
matrix nmc times after discarding the first number of runs specified by 
burnin.
}
\examples{
# Draw 5000 samples of the precision matrix for GHS prior distribution with
# parameter lambda set to 1
prior_sampling(5, 1e3, 5e3, 'GHS', lambda=1)
}
