% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_estimation_functions.R
\name{fmpareto_HR}
\alias{fmpareto_HR}
\title{Parameter fitting for multivariate Huesler--Reiss Pareto distribution}
\usage{
fmpareto_HR(data, p = NULL, cens = FALSE, init, maxit = 100,
  graph = NULL, method = "BFGS")
}
\arguments{
\item{data}{Numeric matrix of size \eqn{n\times d}{n x d}, where \eqn{n} is the
number of observations and \eqn{d} is the dimension.}

\item{p}{Numeric between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} are already on multivariate Pareto scale. Else,
\code{p} is used as the probability in the function \code{\link{data2mpareto}}
to standardize the \code{data}.}

\item{cens}{Logical. If true, then censored likelihood contributions are used for
components below the threshold. By default, \code{cens = FALSE}.}

\item{init}{Numeric vector. Initial parameter values in the optimization. If
\code{graph} is given, then the entries should correspond to the edges of the \code{graph}.}

\item{maxit}{Positive integer. The maximum number of iterations in the
optimization.}

\item{graph}{Graph object from \code{igraph} package or \code{NULL}.
If provided, the \code{graph} must be an undirected block graph, i.e., a decomposable, connected
graph with singleton separator sets.}

\item{method}{String. A valid optimization method used by the function
\code{\link[stats]{optim}}. By default, \code{method = "BFGS"}.}
}
\value{
List consisting of:
\itemize{
\item \code{convergence}: Logical. Indicates whether the optimization converged or not.
\item \code{par}: Numeric vector. Optimized parameters.
\item \code{Gamma}: Numeric matrix \eqn{d \times d}{d x d}. Fitted variogram
matrix.
\item \code{nllik}: Numeric. Optimized value of the negative log-likelihood function.
\item \code{hessian}: Numeric matrix. Estimated Hessian matrix of the
estimated parameters.
}
}
\description{
Fits the parameters of a multivariate Huesler--Reiss Pareto distribution
using (censored) likelihood estimation.
}
\details{
If \code{graph = NULL}, then the parameters of a \eqn{d \times d}{d x d}
parameter matrix \eqn{\Gamma} of a Huesler--Reiss Pareto distribution are fitted.
If \code{graph} is provided, then the conditional independence
structure of this graph is assumed and the parameters on the edges are fitted.
In both cases the full likelihood is used and therefore this function should only
be used for small dimensions, say, \eqn{d<5}. For models in higher dimensions
fitting can be done separately on the cliques; see \code{\link{fmpareto_graph_HR}}.
}
