% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_helpers.R
\name{simu_px_tree_dirichlet}
\alias{simu_px_tree_dirichlet}
\title{Simulate Dirichlet extremal functions on a tree}
\usage{
simu_px_tree_dirichlet(n, alpha.start, alpha.end, A)
}
\arguments{
\item{n}{Number of simulations.}

\item{alpha.start}{Numeric vector with \eqn{d - 1} elements, where \eqn{d} is
the number of nodes in the tree (and \eqn{d - 1} is the number of edges).}

\item{alpha.end}{Numeric vector with \eqn{d - 1} elements, where \eqn{d} is
the number of nodes in the tree (and \eqn{d - 1} is the number of edges).}

\item{A}{Numeric matrix \eqn{d \times (d - 1)}; the rows represent the
nodes in the tree, the columns represent the edges. For a fixed node
\eqn{k = 1, \dots, d}{k = 1, ..., d}, each entry \eqn{(i, j)} is
equal to 1 if the edge in position \eqn{j} is on the directed path from node
\eqn{k} to node \eqn{i} in the polytree rooted at node \eqn{k}.}
}
\value{
Numeric matrix \eqn{n\times d}{n x d}. Simulated data.
}
\description{
Simulates Dirichlet extremal functions on a tree
}
