% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_param_MLE.R
\name{parToMatricesFactory}
\alias{parToMatricesFactory}
\title{Factory: parToMatrices}
\usage{
parToMatricesFactory(
  graph,
  init = NULL,
  fixParams = integer(0),
  parIsTheta = FALSE,
  checkValidity = TRUE
)
}
\arguments{
\item{graph}{\code{par} represents entries corresponding to the edges of \code{graph}.}

\item{init}{The values used for fixed parameters}

\item{fixParams}{The indices (logical or numeric) of fixed parameters in the full parameter vector.}

\item{parIsTheta}{\code{TRUE} if \code{par} represents entries in Theta (otherwise Gamma)}

\item{checkValidity}{Whether to check if the implied Gamma/Theta is a valid parameter matrix.}
}
\value{
A function \code{parToMatrices(par, forceGamma=FALSE, forceTheta=FALSE)},
which takes a parameter vector and returns either \code{NULL} or a list with entries \code{Gamma}, \code{Theta}.
The function returns \code{NULL} if \code{checkValidity==TRUE} and \code{par} implies an invalid matrix.
Otherwise, depending on \code{parIsTheta}, \code{forceTheta}, and \code{forceGamma}, one or both of
\code{Gamma} and \code{Theta} are matrices implied by \code{par}.
}
\description{
Creates a helper function to convert a parameter vector \code{par} to a Gamma and/or Theta matrix.
}
\keyword{internal}
