% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.completion.R
\name{est.completion}
\alias{est.completion}
\title{Estimate graphons based on matrix completion scheme}
\usage{
est.completion(A, rank = NA, tolerance = 0.001, maxiter = 20,
  progress = FALSE, adjust = TRUE)
}
\arguments{
\item{A}{either \describe{
\item{Case 1.}{an \eqn{(n\times n)} binary adjacency matrix, or}
\item{Case 2.}{a list containing multiple of \eqn{(n\times n)} binary adjacency matrices.}
}}

\item{rank}{an estimated rank condition for the matrix; \code{NA} for automatic guessing
of a rank, or a positive integer for a user-supplied rank assumption.}

\item{tolerance}{a tolerance level for singular value thresholding from OptSpace method.}

\item{maxiter}{the number of maximum iterations for OptSpace method.}

\item{progress}{a logical value; \code{FALSE} for not showing intermediate flags during
the process, \code{TRUE} otherwise.}

\item{adjust}{a logical value; \code{TRUE} to ignore a guessed rank and set it as 2 upon
numerical errors, \code{FALSE} to stop the code.}
}
\value{
an \eqn{(n\times n)} corresponding probability matrix.
}
\description{
\code{est.completion} adopts a matrix completion scheme,
which is common in missing data or matrix reconstruction studies.
When given a multiple of, or a single observation, we consider
non-existent edges as missing entries and apply the completion scheme.
See \code{\link[ROptSpace]{OptSpace}} for a more detailed introduction.
}
\examples{
\dontrun{
## generate a graphon of type No.5 with 3 clusters
W = gmodel.preset(3,id=5)

## create a probability matrix for 100 nodes
graphW = gmodel.block(W,n=100)
P = graphW$P

## draw 10 observations from a given probability matrix
A = gmodel.P(P,rep=10)

## apply the method
res_r3 = est.completion(A,rank=3)       # use rank-3 approximation
res_r9 = est.completion(A,rank=9)       # use rank-9 approximation
res_rN = est.completion(A,adjust=FALSE) # stop the code if guess works poorly

## visualize
par(mfrow=c(1,3))
image(res_r3); title("rank 3")
image(res_r9); title("rank 9")
image(res_rN); title("guessed rank")
}

}
\references{
\insertRef{Keshavan2010}{graphon}
}
