% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{agraph}
\alias{agraph}
\alias{agraph_prec}
\title{Segmentation using graph structure}
\usage{
agraph(
  gamma,
  graph,
  lambda = 10^seq(-4, 4, length.out = 50),
  weights = NULL,
  shrinkage = TRUE,
  delta = 1e-10,
  tol = 1e-08,
  thresh = 0.01,
  itermax = 50000
)

agraph_prec(
  gamma,
  graph,
  prec,
  lambda = 10^seq(-4, 4, length.out = 50),
  weights = NULL,
  shrinkage = TRUE,
  delta = 1e-10,
  tol = 1e-08,
  thresh = 0.01,
  itermax = 10000
)
}
\arguments{
\item{gamma}{input vector to regularize}

\item{graph}{an igraph object (from package \code{igraph}) giving the regularization structure}

\item{lambda}{regularizing constant}

\item{weights}{weights for gamma. Default value is one.}

\item{shrinkage}{Boolean, defaults TRUE. Whether to return the adaptive ridge estimate as output. If FALSE, the adaptive ridge is used to define a segmentation into zones, and the signal is estimated on each zone using non-penalized estimation.}

\item{delta}{Computational constant in the adaptive ridge reweighting formula.}

\item{tol}{Tolerance to test for convergence of the adaptive ridge}

\item{thresh}{Thresholding constant used to fuse two adjacent regions with close value of \code{gamma}.}

\item{itermax}{Total number of iterations. Default value is 10000. Setting a low value can make the procedure return NULL entries for some values of \code{lambda}.}

\item{prec}{precision matrix (inverse of the variance-covariance matrix). Has to be a sparse matrix for efficiency.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{result}: matrix whose rows are the segmented output of input signal \code{gamma}, for each value of \code{lambda}}
\item{\code{bic}, \code{gcv}, and \code{aic}: vectors of length \code{length(lambda)}, giving the BIC, GCV, and AIC criteria for each value of lambda. See references below.}
\item{\code{model_dim}, \code{nll}: vectors of length \code{length(lambda)}, giving the model dimension and negative log-likelihood for each value of lambda. See reference below for the definition of these terms.}
}
}
\description{
These functions provide a clustering of a signal on graph into a piecewise constant
signal on graph. Given a graph and a signal \code{gamma} assigning a value to each node,
it returns another signal which is constant over subgraphs where \code{gamma} has
close to equal value. See references.

Only parameters \code{gamma} and \code{graph} need be provided. The other parameters concern
the internals of the estimating procedure and usually do not need to be changed.
\code{agraph} is the general-purpose function. \code{agraph_prec} does the same thing as
\code{agraph} in the case where \code{gamma} as a covariance structure. It is provided as
the precision matrix \code{prec}, which has to be a sparse matrix (\code{Matrix::sparseMatrix})
for fast computation. See Goepp and van de Kassteele (2021).
}
\references{
Schwarz G. (1978)
Estimating the Dimension of a Model.
Ann. Statist. 6 (2) 461 - 464, March, 1978.
\doi{10.1214/aos/1176344136}

Akaike H. (1974)
A new look at the statistical model identification,
in IEEE Transactions on Automatic Control, vol. 19, no. 6, pp. 716-723, December 1974
\doi{10.1109/TAC.1974.1100705}

Hastie T., Friedman J., and Tibshirani R. (2009)
The elements of statistical learning: data mining, inference, and prediction (Vol. 2, pp. 1-758).
New York: Springer
\doi{10.1007/978-0-387-21606-5}

Goepp V. and van de Kassteele J. (2021)
Graph-Based Spatial Segmentation of Health-Related Areal Data,
arxiv preprint.
\doi{10.48550/arXiv.2206.06752}
}
\seealso{
\code{\link[=flsa_graph]{flsa_graph()}}
}
