% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{derivatives}
\alias{derivatives}
\alias{derivatives.default}
\alias{derivatives.gamm}
\alias{derivatives.gam}
\title{Derivatives of estimated smooths via finite differences}
\usage{
derivatives(object, ...)

\method{derivatives}{default}(object, ...)

\method{derivatives}{gamm}(object, ...)

\method{derivatives}{gam}(object, term, newdata, order = 1L,
  type = c("forward", "backward", "central"), n = 200, eps = 1e-07,
  interval = c("confidence", "simultaneous"), n_sim = 10000,
  level = 0.95, unconditional = FALSE, frequentist = FALSE,
  offset = NULL, ...)
}
\arguments{
\item{object}{an R object to compute derivatives for.}

\item{...}{arguments passed to other methods.}

\item{term}{character; vector of one or more smooth terms for which
derivatives are required. If missing, derivatives for all smooth terms
will be returned. Can be a partial match to a smooth term.}

\item{newdata}{a data frame containing the values of the model covariates
at which to evaluate the first derivatives of the smooths.}

\item{order}{numeric; the order of derivative.}

\item{type}{character; the type of finite difference used. One of
\code{"forward"}, \code{"backward"}, or \code{"central"}.}

\item{n}{numeric; the number of points to evaluate the derivative at.}

\item{eps}{numeric; the finite difference.}

\item{interval}{character; the type of interval to compute. One of
\code{"confidence"} for point-wise intervals, or \code{"simultaneous"} for
simultaneous intervals.}

\item{n_sim}{integer; the number of simulations used in computing the
simultaneous intervals.}

\item{level}{numeric; \code{0 < level < 1}; the confidence level of the
point-wise or simultaneous interval. The default is \code{0.95} for a 95%
interval.}

\item{unconditional}{logical; use smoothness selection-corrected Bayesian
covariance matrix?}

\item{frequentist}{logical; use the frequentist covariance matrix?}

\item{offset}{numeric; a value to use for any offset term}
}
\description{
Derivatives of estimated smooths via finite differences
}
\examples{

suppressPackageStartupMessages(library("mgcv"))
\dontshow{
set.seed(42)
op <- options(cli.unicode = FALSE)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2, verbose = FALSE)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivative of all smooths using central finite differenc
derivatives(mod, type = "central")
\dontshow{options(op)}
}
\author{
Gavin L. Simpson
}
