% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.evaluated_smooth}
\alias{draw.evaluated_smooth}
\alias{draw.evaluated_1d_smooth}
\alias{draw.evaluated_2d_smooth}
\alias{geom_rug}
\alias{draw.evaluated_re_smooth}
\alias{draw.evaluated_fs_smooth}
\alias{draw.evaluated_parametric_term}
\title{Plot estimated smooths}
\usage{
\method{draw}{evaluated_1d_smooth}(
  object,
  rug = NULL,
  ci_level = 0.95,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  partial_residuals = NULL,
  response_range = NULL,
  ...
)

\method{draw}{evaluated_2d_smooth}(
  object,
  show = c("estimate", "se"),
  contour = TRUE,
  contour_col = "black",
  n_contour = NULL,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  response_range = NULL,
  continuous_fill = NULL,
  ...
)

\method{draw}{evaluated_re_smooth}(
  object,
  qq_line = TRUE,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  response_range = NULL,
  ...
)

\method{draw}{evaluated_fs_smooth}(
  object,
  rug = NULL,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  response_range = NULL,
  discrete_colour = NULL,
  ...
)

\method{draw}{evaluated_parametric_term}(
  object,
  ci_level = 0.95,
  constant = NULL,
  fun = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  rug = TRUE,
  position = "identity",
  response_range = NULL,
  ...
)
}
\arguments{
\item{object}{an object, the result of a call to \code{\link[=evaluate_smooth]{evaluate_smooth()}}.}

\item{rug}{For \code{evaluate_smooth()}, a numeric vector of values for the
location of data on the x axis. The default of \code{NULL} results in no
rug plot being drawn. For \code{evaluate_parametric_terms()}, a logical to
indicate if a rug plot should be drawn.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{xlab}{character or expression; the label for the x axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{partial_residuals}{data frame; partial residuals and data values if
partial residuals are drawn. Should have names \code{..p_resid} and \code{..orig_x} if
supplied.}

\item{response_range}{numeric; a vector of two values giving the range of
response data for the guide. Used to fix plots to a common scale/range.
Ignored if \code{show} is set to \code{"se"}.}

\item{...}{arguments passed to other methods.}

\item{show}{character; plot the estimated smooth (\code{"estimate"}) or its
standard error (\code{"se"}).}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{continuous_fill}{suitable scale used for the filled surface. If \code{NULL},
the default used is \code{scale_fill_distiller(palette = "RdBu", type = "div")}.}

\item{qq_line}{logical; draw a reference line through the lower and upper
theoretical quartiles.}

\item{discrete_colour}{an appropriate discrete colour scale from \code{ggplot2}.
The scale will need to be able to provide as many colours as there are
levels in the factor variable involved in the smooth. Suitable alternatives
include \code{\link[ggplot2:scale_viridis]{ggplot2::scale_colour_viridis_d()}}.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plots estimated univariate and bivariate smooths using ggplot2.
}
\examples{
load_mgcv()

\dontshow{set.seed(2)}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

sm <- evaluate_smooth(m1, "s(x2)")
draw(sm)

## supply constant to shift y axis scale
draw(sm, constant = coef(m1)[1])

\dontshow{set.seed(2)}
dat <- gamSim(2, n = 1000, dist = "normal", scale = 1)
m2 <- gam(y ~ s(x, z, k = 40), data = dat$data, method = "REML")

sm <- evaluate_smooth(m2, "s(x,z)", n = 100)
draw(sm)
}
\author{
Gavin L. Simpson
}
