% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_smooth2.R
\name{smooth_estimates}
\alias{smooth_estimates}
\alias{smooth_estimates.gam}
\title{New \code{evaluate_smooth()} alike}
\usage{
smooth_estimates(object, ...)

\method{smooth_estimates}{gam}(
  object,
  smooth = NULL,
  n = 100,
  newdata = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = 0.1,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"gam"} or \code{"gamm"}.}

\item{...}{arguments passed to other methods.}

\item{smooth}{character; a single smooth to evaluate.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{newdata}{a vector or data frame of points at which to evaluate the
smooth.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}
}
\value{
A data frame (tibble), which is of class \code{"smooth_estimates"}.
}
\description{
New \code{evaluate_smooth()} alike
}
\examples{
load_mgcv()
\dontshow{
set.seed(2)
op <- options(cli.unicode = FALSE, digits = 6)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## evaluate all smooths
smooth_estimates(m1)

## or selected smooths
smooth_estimates(m1, smooth = c("s(x0)", "s(x1)"))
\dontshow{options(op)}
}
